/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.TopologyMember;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.impl.TopologyMemberImpl;
import org.hornetq.spi.core.remoting.Connector;

public final class Topology
implements Serializable {
    private static final long serialVersionUID = -9037171688692471371L;
    private final Set<ClusterTopologyListener> topologyListeners = new HashSet<ClusterTopologyListener>();
    private transient Executor executor = null;
    private volatile Object owner;
    private final Map<String, TopologyMemberImpl> topology = new ConcurrentHashMap<String, TopologyMemberImpl>();
    private transient Map<String, Long> mapDelete;

    public Topology(Object owner) {
        this.owner = owner;
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("Topology@" + Integer.toHexString(System.identityHashCode(this)) + " CREATE", new Exception("trace"));
        }
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterTopologyListener(ClusterTopologyListener listener) {
        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
            HornetQClientLogger.LOGGER.debug(this + "::Adding topology listener " + listener, new Exception("Trace"));
        }
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            this.topologyListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterTopologyListener(ClusterTopologyListener listener) {
        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
            HornetQClientLogger.LOGGER.debug(this + "::Removing topology listener " + listener, new Exception("Trace"));
        }
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            this.topologyListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsLive(String nodeId, TopologyMemberImpl memberInput) {
        Topology topology = this;
        synchronized (topology) {
            if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                HornetQClientLogger.LOGGER.debug(this + "::node " + nodeId + "=" + memberInput);
            }
            memberInput.setUniqueEventID(System.currentTimeMillis());
            this.topology.remove(nodeId);
            this.topology.put(nodeId, memberInput);
            this.sendMemberUp(nodeId, memberInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendNode(String nodeId) {
        Topology topology = this;
        synchronized (topology) {
            TopologyMemberImpl memberInput = this.topology.get(nodeId);
            if (memberInput != null) {
                memberInput.setUniqueEventID(System.currentTimeMillis());
                this.sendMemberUp(nodeId, memberInput);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TopologyMemberImpl updateBackup(TopologyMemberImpl memberInput) {
        String nodeId = memberInput.getNodeId();
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace(this + "::updateBackup::" + nodeId + ", memberInput=" + memberInput);
        }
        Topology topology = this;
        synchronized (topology) {
            TopologyMemberImpl currentMember = this.getMember(nodeId);
            if (currentMember == null) {
                HornetQClientLogger.LOGGER.debug("There's no live to be updated on backup update, node=" + nodeId + " memberInput=" + memberInput, new Exception("trace"));
                currentMember = memberInput;
                this.topology.put(nodeId, currentMember);
            }
            TopologyMemberImpl newMember = new TopologyMemberImpl(nodeId, currentMember.getBackupGroupName(), currentMember.getLive(), memberInput.getBackup());
            newMember.setUniqueEventID(System.currentTimeMillis());
            this.topology.remove(nodeId);
            this.topology.put(nodeId, newMember);
            this.sendMemberUp(nodeId, newMember);
            return newMember;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMember(long uniqueEventID, String nodeId, TopologyMemberImpl memberInput) {
        Long deleteTme = this.getMapDelete().get(nodeId);
        if (deleteTme != null && uniqueEventID != 0L && uniqueEventID < deleteTme) {
            HornetQClientLogger.LOGGER.debug("Update uniqueEvent=" + uniqueEventID + ", nodeId=" + nodeId + ", memberInput=" + memberInput + " being rejected as there was a delete done after that");
            return false;
        }
        Topology topology = this;
        synchronized (topology) {
            TopologyMemberImpl currentMember = this.topology.get(nodeId);
            if (currentMember == null) {
                if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                    HornetQClientLogger.LOGGER.debug(this + "::NewMemeberAdd nodeId=" + nodeId + " member = " + memberInput, new Exception("trace"));
                }
                memberInput.setUniqueEventID(uniqueEventID);
                this.topology.put(nodeId, memberInput);
                this.sendMemberUp(nodeId, memberInput);
                return true;
            }
            if (uniqueEventID > currentMember.getUniqueEventID()) {
                TopologyMemberImpl newMember = new TopologyMemberImpl(nodeId, memberInput.getBackupGroupName(), memberInput.getLive(), memberInput.getBackup());
                if (newMember.getLive() == null && currentMember.getLive() != null) {
                    newMember.setLive(currentMember.getLive());
                }
                if (newMember.getBackup() == null && currentMember.getBackup() != null) {
                    newMember.setBackup(currentMember.getBackup());
                }
                if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                    HornetQClientLogger.LOGGER.debug(this + "::updated currentMember=nodeID=" + nodeId + ", currentMember=" + currentMember + ", memberInput=" + memberInput + "newMember=" + newMember, new Exception("trace"));
                }
                newMember.setUniqueEventID(uniqueEventID);
                this.topology.remove(nodeId);
                this.topology.put(nodeId, newMember);
                this.sendMemberUp(nodeId, newMember);
                return true;
            }
            if (currentMember.getBackup() == null && memberInput.getBackup() != null) {
                currentMember.setBackup(memberInput.getBackup());
            }
            return false;
        }
    }

    private void sendMemberUp(final String nodeId, final TopologyMemberImpl memberToSend) {
        final ArrayList<ClusterTopologyListener> copy = this.copyListeners();
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace(this + "::prepare to send " + nodeId + " to " + copy.size() + " elements");
        }
        if (copy.size() > 0) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    for (ClusterTopologyListener listener : copy) {
                        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
                            HornetQClientLogger.LOGGER.trace(Topology.this + " informing " + listener + " about node up = " + nodeId + " connector = " + memberToSend.getConnector());
                        }
                        try {
                            listener.nodeUP(memberToSend, false);
                        }
                        catch (Throwable e) {
                            HornetQClientLogger.LOGGER.errorSendingTopology(e);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ClusterTopologyListener> copyListeners() {
        ArrayList<ClusterTopologyListener> listenersCopy;
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            listenersCopy = new ArrayList<ClusterTopologyListener>(this.topologyListeners);
        }
        return listenersCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeMember(final long uniqueEventID, final String nodeId) {
        TopologyMemberImpl member;
        Topology topology = this;
        synchronized (topology) {
            member = this.topology.get(nodeId);
            if (member != null) {
                if (member.getUniqueEventID() > uniqueEventID) {
                    HornetQClientLogger.LOGGER.debug("The removeMember was issued before the node " + nodeId + " was started, ignoring call");
                    member = null;
                } else {
                    this.getMapDelete().put(nodeId, uniqueEventID);
                    member = this.topology.remove(nodeId);
                }
            }
        }
        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
            HornetQClientLogger.LOGGER.debug("removeMember " + this + " removing nodeID=" + nodeId + ", result=" + member + ", size = " + this.topology.size(), new Exception("trace"));
        }
        if (member != null) {
            final ArrayList<ClusterTopologyListener> copy = this.copyListeners();
            this.execute(new Runnable(){

                @Override
                public void run() {
                    for (ClusterTopologyListener listener : copy) {
                        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
                            HornetQClientLogger.LOGGER.trace(this + " informing " + listener + " about node down = " + nodeId);
                        }
                        try {
                            listener.nodeDown(uniqueEventID, nodeId);
                        }
                        catch (Exception e) {
                            HornetQClientLogger.LOGGER.errorSendingTopologyNodedown(e);
                        }
                    }
                }
            });
        }
        return member != null;
    }

    private void execute(Runnable runnable) {
        if (this.executor != null) {
            this.executor.execute(runnable);
        } else {
            runnable.run();
        }
    }

    public synchronized void sendTopology(final ClusterTopologyListener listener) {
        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
            HornetQClientLogger.LOGGER.debug(this + " is sending topology to " + listener);
        }
        this.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap copy;
                int count = 0;
                Topology topology = Topology.this;
                synchronized (topology) {
                    copy = new HashMap(Topology.this.topology);
                }
                for (Map.Entry entry : copy.entrySet()) {
                    if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                        HornetQClientLogger.LOGGER.debug(Topology.this + " sending " + (String)entry.getKey() + " / " + ((TopologyMemberImpl)entry.getValue()).getConnector() + " to " + listener);
                    }
                    listener.nodeUP((TopologyMember)entry.getValue(), ++count == copy.size());
                }
            }
        });
    }

    public synchronized TopologyMemberImpl getMember(String nodeID) {
        return this.topology.get(nodeID);
    }

    public synchronized boolean isEmpty() {
        return this.topology.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TopologyMemberImpl> getMembers() {
        ArrayList<TopologyMemberImpl> members;
        Topology topology = this;
        synchronized (topology) {
            members = new ArrayList<TopologyMemberImpl>(this.topology.values());
        }
        return members;
    }

    synchronized int nodes() {
        int count = 0;
        for (TopologyMemberImpl member : this.topology.values()) {
            if (member.getLive() != null) {
                ++count;
            }
            if (member.getBackup() == null) continue;
            ++count;
        }
        return count;
    }

    public synchronized String describe() {
        return this.describe("");
    }

    private synchronized String describe(String text) {
        StringBuilder desc = new StringBuilder(text + "topology on " + this + ":\n");
        for (Map.Entry<String, TopologyMemberImpl> entry : new HashMap<String, TopologyMemberImpl>(this.topology).entrySet()) {
            desc.append("\t" + entry.getKey() + " => " + entry.getValue() + "\n");
        }
        desc.append("\tnodes=" + this.nodes() + "\t" + "members=" + this.members());
        if (this.topology.isEmpty()) {
            desc.append("\tEmpty");
        }
        return desc.toString();
    }

    private int members() {
        return this.topology.size();
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public TransportConfiguration getBackupForConnector(Connector connector) {
        for (TopologyMemberImpl member : this.topology.values()) {
            if (member.getLive() == null || !connector.isEquivalent(member.getLive().getParams())) continue;
            return member.getBackup();
        }
        return null;
    }

    public String toString() {
        if (this.owner == null) {
            return "Topology@" + Integer.toHexString(System.identityHashCode(this));
        }
        return "Topology@" + Integer.toHexString(System.identityHashCode(this)) + "[owner=" + this.owner + "]";
    }

    private synchronized Map<String, Long> getMapDelete() {
        if (this.mapDelete == null) {
            this.mapDelete = new ConcurrentHashMap<String, Long>();
        }
        return this.mapDelete;
    }
}

