/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.AddPropertiesUser;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.ConfirmationChoice;
import org.jboss.as.domain.management.security.state.ErrorState;
import org.jboss.as.domain.management.security.state.PromptPasswordState;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;

public class PromptNewUserState
implements State {
    private final StateValues stateValues;
    private ConsoleWrapper theConsole;

    public PromptNewUserState(ConsoleWrapper theConsole) {
        this.theConsole = theConsole;
        this.stateValues = new StateValues();
        this.stateValues.setRealm("ManagementRealm");
    }

    public PromptNewUserState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        if (stateValues != null && !stateValues.isSilent() && theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        State continuingState = new PromptPasswordState(this.theConsole, this.stateValues);
        if (!this.stateValues.isSilentOrNonInteractive()) {
            String existingUsername;
            this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            this.theConsole.printf(DomainManagementMessages.MESSAGES.enterNewUserDetails(), new Object[0]);
            this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            this.stateValues.setPassword(null);
            this.theConsole.printf(DomainManagementMessages.MESSAGES.realmPrompt(this.stateValues.getRealm()), new Object[0]);
            String temp = this.theConsole.readLine(" : ", new Object[0]);
            if (temp == null) {
                this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                return null;
            }
            if (temp.length() > 0) {
                this.stateValues.setRealm(temp);
            }
            String usernamePrompt = (existingUsername = this.stateValues.getUserName()) == null ? DomainManagementMessages.MESSAGES.usernamePrompt() : DomainManagementMessages.MESSAGES.usernamePrompt(existingUsername);
            this.theConsole.printf(usernamePrompt, new Object[0]);
            temp = this.theConsole.readLine(" : ", new Object[0]);
            if (temp != null && temp.length() > 0) {
                existingUsername = temp;
            }
            if (temp == null || existingUsername == null || existingUsername.length() == 0) {
                return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.noUsernameExiting());
            }
            this.stateValues.setUserName(existingUsername);
            if (this.stateValues.getKnownUsers().contains(this.stateValues.getUserName())) {
                PromptNewUserState duplicateContinuing;
                PromptNewUserState promptNewUserState = duplicateContinuing = this.stateValues.isSilentOrNonInteractive() ? null : new PromptNewUserState(this.theConsole, this.stateValues);
                if (this.stateValues.isSilentOrNonInteractive()) {
                    continuingState = new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.duplicateUser(this.stateValues.getUserName()), duplicateContinuing, this.stateValues);
                } else {
                    String message = DomainManagementMessages.MESSAGES.aboutToUpdateUser(this.stateValues.getUserName());
                    String prompt = DomainManagementMessages.MESSAGES.isCorrectPrompt() + " " + DomainManagementMessages.MESSAGES.yes() + "/" + DomainManagementMessages.MESSAGES.no() + "?";
                    this.stateValues.setExistingUser(true);
                    continuingState = new ConfirmationChoice(this.theConsole, message, prompt, continuingState, duplicateContinuing);
                }
            }
        }
        return continuingState;
    }
}

