/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.JavaConsole;
import org.jboss.as.domain.management.security.state.ErrorState;
import org.jboss.as.domain.management.security.state.PropertyFileFinder;
import org.jboss.as.domain.management.security.state.PropertyFilePrompt;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;

public class AddPropertiesUser {
    public static final String[] BAD_USER_NAMES = new String[]{"admin", "administrator", "root"};
    public static final String SERVER_BASE_DIR = "jboss.server.base.dir";
    public static final String SERVER_CONFIG_DIR = "jboss.server.config.dir";
    public static final String SERVER_CONFIG_USER_DIR = "jboss.server.config.user.dir";
    public static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    public static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    public static final String DOMAIN_CONFIG_USER_DIR = "jboss.domain.config.user.dir";
    public static final String DEFAULT_MANAGEMENT_REALM = "ManagementRealm";
    public static final String DEFAULT_APPLICATION_REALM = "ApplicationRealm";
    public static final String MGMT_USERS_PROPERTIES = "mgmt-users.properties";
    public static final String APPLICATION_USERS_PROPERTIES = "application-users.properties";
    public static final String APPLICATION_ROLES_PROPERTIES = "application-roles.properties";
    public static final String NEW_LINE = String.format("%n", new Object[0]);
    public static final String SPACE = " ";
    private static final Properties argsCliProps = new Properties();
    private final ConsoleWrapper theConsole;
    protected State nextState;

    protected AddPropertiesUser(ConsoleWrapper console) {
        this.theConsole = console;
        StateValues stateValues = new StateValues();
        stateValues.setJbossHome(System.getenv("JBOSS_HOME"));
        if (this.theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
        this.nextState = new PropertyFilePrompt(this.theConsole, stateValues);
    }

    private AddPropertiesUser(ConsoleWrapper console, boolean management, String user, String password, String realm) {
        StateValues stateValues = new StateValues();
        stateValues.setJbossHome(System.getenv("JBOSS_HOME"));
        boolean silent = Boolean.valueOf(argsCliProps.getProperty(CommandLineArgument.SILENT.key()));
        Interactiveness howInteractive = silent ? Interactiveness.SILENT : Interactiveness.NON_INTERACTIVE;
        stateValues.setHowInteractive(howInteractive);
        this.theConsole = console;
        if (this.theConsole.getConsole() == null && !howInteractive.equals((Object)Interactiveness.SILENT)) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
        if (user == null || user.isEmpty()) {
            this.nextState = new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.noUsernameExiting(), null, stateValues);
            return;
        }
        stateValues.setUserName(user);
        if (password == null || password.isEmpty()) {
            this.nextState = new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.noPasswordExiting(), null, stateValues);
            return;
        }
        stateValues.setPassword(password.toCharArray());
        stateValues.setRealm(realm);
        stateValues.setManagement(management);
        stateValues.setRoles(argsCliProps.getProperty(CommandLineArgument.ROLE.key()));
        this.nextState = new PropertyFileFinder(this.theConsole, stateValues);
    }

    private AddPropertiesUser(ConsoleWrapper consoleWrapper, boolean management, String user, String password) {
        this(consoleWrapper, management, user, password, management ? DEFAULT_MANAGEMENT_REALM : DEFAULT_APPLICATION_REALM);
    }

    protected void run() {
        while ((this.nextState = this.nextState.execute()) != null) {
        }
    }

    public static void main(String[] args) {
        boolean management = true;
        JavaConsole javaConsole = new JavaConsole();
        if (args.length >= 1) {
            Iterator<String> it = Arrays.asList(args).iterator();
            while (it.hasNext()) {
                String temp = it.next();
                if (CommandLineArgument.HELP.match(temp)) {
                    AddPropertiesUser.usage(javaConsole);
                    return;
                }
                if (CommandLineArgument.DOMAIN_CONFIG_DIR_USERS.match(temp)) {
                    System.setProperty(DOMAIN_CONFIG_DIR, it.next());
                    continue;
                }
                if (CommandLineArgument.SERVER_CONFIG_DIR_USERS.match(temp)) {
                    System.setProperty(SERVER_CONFIG_DIR, it.next());
                    continue;
                }
                if (CommandLineArgument.APPLICATION_USERS.match(temp)) {
                    management = false;
                    continue;
                }
                CommandLineArgument commandLineArgument = AddPropertiesUser.findCommandLineOption(temp);
                if (commandLineArgument != null) {
                    String value;
                    if (CommandLineArgument.SILENT.equals((Object)commandLineArgument)) {
                        value = Boolean.TRUE.toString();
                    } else {
                        String string = value = it.hasNext() ? it.next() : null;
                    }
                    if (value == null) continue;
                    argsCliProps.setProperty(commandLineArgument.key(), value);
                    continue;
                }
                String userKey = CommandLineArgument.USER.key();
                if (!argsCliProps.containsKey(userKey)) {
                    argsCliProps.setProperty(userKey, temp);
                    continue;
                }
                String passwordKey = CommandLineArgument.PASSWORD.key();
                if (!argsCliProps.containsKey(passwordKey)) {
                    argsCliProps.setProperty(passwordKey, temp);
                    continue;
                }
                String realmKey = CommandLineArgument.REALM.key();
                if (argsCliProps.containsKey(realmKey)) continue;
                argsCliProps.setProperty(realmKey, temp);
            }
        }
        if (argsCliProps.containsKey(CommandLineArgument.PASSWORD.key()) || argsCliProps.containsKey(CommandLineArgument.USER.key())) {
            String password = argsCliProps.getProperty(CommandLineArgument.PASSWORD.key());
            String user = argsCliProps.getProperty(CommandLineArgument.USER.key());
            if (argsCliProps.containsKey(CommandLineArgument.REALM.key())) {
                new AddPropertiesUser(javaConsole, management, user, password, argsCliProps.getProperty(CommandLineArgument.REALM.key())).run();
            } else {
                new AddPropertiesUser(javaConsole, management, user, password).run();
            }
        } else {
            new AddPropertiesUser(javaConsole).run();
        }
    }

    private static void usage(ConsoleWrapper consoleWrapper) {
        CommandLineArgument.printUsage(consoleWrapper);
    }

    private static CommandLineArgument findCommandLineOption(String arg) {
        for (CommandLineArgument commandLineArgument : CommandLineArgument.values()) {
            if (!commandLineArgument.match(arg)) continue;
            return commandLineArgument;
        }
        return null;
    }

    protected static enum CommandLineArgument {
        APPLICATION_USERS("-a"){

            @Override
            public String instructions() {
                return DomainManagementMessages.MESSAGES.argApplicationUsers();
            }
        }
        ,
        DOMAIN_CONFIG_DIR_USERS("-dc"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementMessages.MESSAGES.argDomainConfigDirUsers();
            }
        }
        ,
        SERVER_CONFIG_DIR_USERS("-sc"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementMessages.MESSAGES.argServerConfigDirUsers();
            }
        }
        ,
        PASSWORD("-p", "--password"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementMessages.MESSAGES.argPassword();
            }
        }
        ,
        USER("-u", "--user"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementMessages.MESSAGES.argUser();
            }
        }
        ,
        REALM("-r", "--realm"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementMessages.MESSAGES.argRealm();
            }
        }
        ,
        SILENT("-s", "--silent"){

            @Override
            public String instructions() {
                return DomainManagementMessages.MESSAGES.argSilent();
            }
        }
        ,
        ROLE("-ro", "--role"){

            @Override
            public String argumentExample() {
                return super.argumentExample().concat(" <value>");
            }

            @Override
            public String instructions() {
                return DomainManagementMessages.MESSAGES.argRole();
            }
        }
        ,
        HELP("-h", "--help"){

            @Override
            public String instructions() {
                return DomainManagementMessages.MESSAGES.argHelp();
            }
        };

        private static String USAGE;
        private String shortArg;
        private String longArg;

        private CommandLineArgument(String option) {
            this.shortArg = option;
        }

        private CommandLineArgument(String shortArg, String longArg) {
            this.shortArg = shortArg;
            this.longArg = longArg;
        }

        public String key() {
            return this.longArg != null ? this.longArg.substring(2) : this.shortArg.substring(1);
        }

        public boolean match(String option) {
            return option.equals(this.shortArg) || option.equals(this.longArg);
        }

        public String getShortArg() {
            return this.shortArg;
        }

        public String getLongArg() {
            return this.longArg;
        }

        public String argumentExample() {
            return (null != this.getShortArg() ? this.getShortArg() : "").concat(null != this.getLongArg() ? ", " + this.getLongArg() : "");
        }

        public abstract String instructions();

        public String toString() {
            ArrayList<String> instructions = new ArrayList<String>();
            CommandLineArgument.segmentInstructions(this.instructions(), instructions);
            StringBuilder sb = new StringBuilder(String.format("    %-35s %s", this.argumentExample(), instructions.get(0)));
            for (int i = 1; i < instructions.size(); ++i) {
                sb.append(NEW_LINE);
                sb.append(String.format("%-40s%s", AddPropertiesUser.SPACE, instructions.get(i)));
            }
            sb.append(NEW_LINE);
            return sb.toString();
        }

        private static void segmentInstructions(String instructions, List<String> segments) {
            if (instructions.length() <= 40) {
                segments.add(instructions);
            } else {
                String testFragment = instructions.substring(0, 40);
                int lastSpace = testFragment.lastIndexOf(32);
                if (lastSpace < 0) {
                    lastSpace = 39;
                }
                segments.add(instructions.substring(0, lastSpace + 1));
                CommandLineArgument.segmentInstructions(instructions.substring(lastSpace + 1), segments);
            }
        }

        public static void printUsage(ConsoleWrapper consoleWrapper) {
            consoleWrapper.printf(CommandLineArgument.usage(), new Object[0]);
        }

        public static String usage() {
            if (USAGE == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(DomainManagementMessages.MESSAGES.argUsage()).append(NEW_LINE);
                for (CommandLineArgument arg : CommandLineArgument.values()) {
                    sb.append(arg.toString()).append(NEW_LINE);
                }
                USAGE = sb.toString();
            }
            return USAGE;
        }
    }

    public static enum Interactiveness {
        SILENT,
        NON_INTERACTIVE,
        INTERACTIVE;

    }
}

