/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashSet;
import java.util.Set;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.SecurityRoleDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class SecurityRoleAttributeHandler
extends AbstractWriteAttributeHandler<Set<Role>> {
    static final SecurityRoleAttributeHandler INSTANCE = new SecurityRoleAttributeHandler();

    private SecurityRoleAttributeHandler() {
        super((AttributeDefinition[])SecurityRoleDefinition.ATTRIBUTES);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Set<Role>> handbackHolder) throws OperationFailedException {
        HornetQServer server = SecurityRoleAttributeHandler.getServer(context, operation);
        if (server != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String match = address.getElement(address.size() - 2).getValue();
            String roleName = address.getLastElement().getValue();
            HashSet<Role> newRoles = new HashSet<Role>();
            Set roles = (Set)server.getSecurityRepository().getMatch(match);
            handbackHolder.setHandback((Object)roles);
            for (Role role : roles) {
                if (roleName.equals(role.getName())) continue;
                newRoles.add(role);
            }
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode subModel = resource.getModel();
            Role updatedRole = SecurityRoleDefinition.transform(context, roleName, subModel);
            newRoles.add(updatedRole);
            server.getSecurityRepository().addMatch(match, newRoles);
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Set<Role> handback) throws OperationFailedException {
        HornetQServer server;
        if (handback != null && (server = SecurityRoleAttributeHandler.getServer(context, operation)) != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String match = address.getElement(address.size() - 2).getValue();
            server.getSecurityRepository().addMatch(match, handback);
        }
    }

    static HornetQServer getServer(OperationContext context, ModelNode operation) {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController controller = context.getServiceRegistry(true).getService(hqServiceName);
        if (controller != null) {
            return (HornetQServer)HornetQServer.class.cast(controller.getValue());
        }
        return null;
    }
}

