/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.dmr.ModelNode;

public interface OperationTransformers {

    public static final class InsertDefaultValuesOperationTransformer
    implements OperationTransformer {
        private final AttributeDefinition[] definitions;

        public InsertDefaultValuesOperationTransformer(AttributeDefinition ... definitions) {
            this.definitions = definitions;
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            for (AttributeDefinition attr : this.definitions) {
                if (operation.hasDefined(attr.getName())) continue;
                operation.get(attr.getName()).set(attr.getDefaultValue());
            }
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }

    public static final class FailUnignoredAttributesOperationTransformer
    implements OperationTransformer {
        private final AttributeDefinition[] definitions;

        public FailUnignoredAttributesOperationTransformer(AttributeDefinition ... definitions) {
            this.definitions = definitions;
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            final ArrayList<String> found = new ArrayList<String>();
            for (AttributeDefinition attr : this.definitions) {
                if (!operation.require("name").asString().equals(attr.getName())) continue;
                found.add(attr.getName());
            }
            return new OperationTransformer.TransformedOperation(operation, new OperationRejectionPolicy(){

                public boolean rejectOperation(ModelNode preparedResult) {
                    return found.size() > 0;
                }

                public String getFailureDescription() {
                    return MessagingMessages.MESSAGES.unsupportedAttributeInVersion(found.toString(), MessagingExtension.VERSION_1_1_0);
                }
            }, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }
}

