/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.DiscardUndefinedAttributesTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.RejectExpressionValuesTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.controller.transform.chained.ChainedOperationTransformer;
import org.jboss.as.messaging.AddressSettingDefinition;
import org.jboss.as.messaging.BridgeDefinition;
import org.jboss.as.messaging.BroadcastGroupDefinition;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceDefinition;
import org.jboss.as.messaging.ConnectorServiceParamDefinition;
import org.jboss.as.messaging.DiscoveryGroupDefinition;
import org.jboss.as.messaging.DivertDefinition;
import org.jboss.as.messaging.GroupingHandlerDefinition;
import org.jboss.as.messaging.HornetQServerResourceDefinition;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.MessagingPathHandlers;
import org.jboss.as.messaging.OperationTransformers;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.as.messaging.TransportParamDefinition;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.ConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.JMSQueueDefinition;
import org.jboss.as.messaging.jms.JMSTopicDefinition;
import org.jboss.as.messaging.jms.PooledConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.bridge.JMSBridgeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class MessagingTransformers {
    static void registerTransformers(SubsystemRegistration subsystem) {
        MessagingTransformers.registerTransformers_1_1_0(subsystem);
    }

    private static void registerTransformers_1_1_0(SubsystemRegistration subsystem) {
        TransformersSubRegistration transport;
        TransformersSubRegistration transformers = subsystem.registerModelTransformers((ModelVersionRange)MessagingExtension.VERSION_1_1_0, new ResourceTransformer(){

            private void removeAttributes(ModelNode model, AttributeDefinition ... removedAttributes) {
                for (AttributeDefinition attr : removedAttributes) {
                    model.remove(attr.getName());
                }
            }

            public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                ModelNode oldModel = resource.getModel();
                if (oldModel.hasDefined("hornetq-server")) {
                    for (Property server : oldModel.get("hornetq-server").asPropertyList()) {
                        ModelNode oldServer = oldModel.get(new String[]{"hornetq-server", server.getName()});
                        if (!oldServer.hasDefined(CommonAttributes.CLUSTERED.getName())) {
                            oldServer.get(CommonAttributes.CLUSTERED.getName()).set(false);
                        }
                        this.removeAttributes(oldServer, HornetQServerResourceDefinition.NEW_ATTRIBUTES_ADDED_AFTER_1_1_0);
                        if (server.getValue().hasDefined("cluster-connection")) {
                            for (Property clusterConnection : server.getValue().get("cluster-connection").asPropertyList()) {
                                this.removeAttributes(oldServer.get(new String[]{"cluster-connection", clusterConnection.getName()}), ClusterConnectionDefinition.NEW_ATTRIBUTES_ADDED_AFTER_1_1_0);
                            }
                        }
                        if (server.getValue().hasDefined("broadcast-group")) {
                            for (Property broadcastGroup : server.getValue().get("broadcast-group").asPropertyList()) {
                                this.removeAttributes(oldServer.get(new String[]{"broadcast-group", broadcastGroup.getName()}), BroadcastGroupDefinition.NEW_ATTRIBUTES_ADDED_AFTER_1_1_0);
                            }
                        }
                        if (server.getValue().hasDefined("discovery-group")) {
                            for (Property discoveryGroup : server.getValue().get("discovery-group").asPropertyList()) {
                                this.removeAttributes(oldServer.get(new String[]{"discovery-group", discoveryGroup.getName()}), DiscoveryGroupDefinition.NEW_ATTRIBUTES_ADDED_AFTER_1_1_0);
                            }
                        }
                        if (server.getValue().hasDefined("pooled-connection-factory")) {
                            for (Property pooledConnectionFactory : server.getValue().get("pooled-connection-factory").asPropertyList()) {
                                this.removeAttributes(oldServer.get(new String[]{"pooled-connection-factory", pooledConnectionFactory.getName()}), PooledConnectionFactoryDefinition.NEW_ATTRIBUTES_ADDED_AFTER_1_1_0);
                            }
                        }
                        if (server.getValue().hasDefined("connection-factory")) {
                            for (Property connectionFactory : server.getValue().get("connection-factory").asPropertyList()) {
                                this.removeAttributes(oldServer.get(new String[]{"connection-factory", connectionFactory.getName()}), ConnectionFactoryDefinition.NEW_ATTRIBUTES_ADDED_AFTER_1_1_0);
                                if (!connectionFactory.getValue().hasDefined(CommonAttributes.HA.getName())) {
                                    oldServer.get(new String[]{"connection-factory", connectionFactory.getName()}).get(CommonAttributes.HA.getName()).set(CommonAttributes.HA.getDefaultValue());
                                }
                                if (!connectionFactory.getValue().hasDefined(ConnectionFactoryAttributes.Regular.FACTORY_TYPE.getName()) || !connectionFactory.getValue().get(ConnectionFactoryAttributes.Regular.FACTORY_TYPE.getName()).equals(ConnectionFactoryAttributes.Regular.FACTORY_TYPE.getDefaultValue())) continue;
                                oldServer.get(new String[]{"connection-factory", connectionFactory.getName()}).get(ConnectionFactoryAttributes.Regular.FACTORY_TYPE.getName()).set(new ModelNode());
                            }
                        }
                        if (server.getValue().hasDefined("core-address")) {
                            oldServer.remove("core-address");
                        }
                        if (!server.getValue().hasDefined("runtime-queue")) continue;
                        oldServer.remove("runtime-queue");
                    }
                }
                resource.writeModel(oldModel);
            }
        });
        RejectExpressionValuesTransformer rejectServerExpressionTransformer = new RejectExpressionValuesTransformer(HornetQServerResourceDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        DiscardUndefinedAttributesTransformer discardUndefinedServerAttributes = new DiscardUndefinedAttributesTransformer(HornetQServerResourceDefinition.NEW_ATTRIBUTES_ADDED_AFTER_1_1_0);
        TransformersSubRegistration server = transformers.registerSubResource(PathElement.pathElement((String)"hornetq-server"));
        server.registerOperationTransformer("add", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{new OperationTransformers.InsertDefaultValuesOperationTransformer(new AttributeDefinition[]{CommonAttributes.ID_CACHE_SIZE, CommonAttributes.CLUSTERED}), rejectServerExpressionTransformer, discardUndefinedServerAttributes}));
        server.registerOperationTransformer("write-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{rejectServerExpressionTransformer.getWriteAttributeTransformer(), discardUndefinedServerAttributes.getWriteAttributeTransformer()}));
        server.registerOperationTransformer("undefine-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{discardUndefinedServerAttributes.getUndefineAttributeTransformer()}));
        MessagingTransformers.rejectExpressions(server, AddressSettingDefinition.PATH, AddressSettingDefinition.REJECTED_EXPRESSION_ATTRIBUTES);
        DiscardUndefinedAttributesTransformer discardBroadcastUndefinedAttributes = new DiscardUndefinedAttributesTransformer(BroadcastGroupDefinition.NEW_ATTRIBUTES_ADDED_AFTER_1_1_0);
        RejectExpressionValuesTransformer rejectBroadcastGroupExpressions = new RejectExpressionValuesTransformer(BroadcastGroupDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        TransformersSubRegistration broadcastGroup = server.registerSubResource(BroadcastGroupDefinition.PATH);
        broadcastGroup.registerOperationTransformer("add", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{rejectBroadcastGroupExpressions, discardBroadcastUndefinedAttributes}));
        broadcastGroup.registerOperationTransformer("write-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{rejectBroadcastGroupExpressions.getWriteAttributeTransformer(), discardBroadcastUndefinedAttributes.getWriteAttributeTransformer()}));
        broadcastGroup.registerOperationTransformer("undefine-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{discardBroadcastUndefinedAttributes.getUndefineAttributeTransformer()}));
        DiscardUndefinedAttributesTransformer discardDiscoveryGroupUndefinedAttributes = new DiscardUndefinedAttributesTransformer(DiscoveryGroupDefinition.NEW_ATTRIBUTES_ADDED_AFTER_1_1_0);
        RejectExpressionValuesTransformer rejectDiscoveryGroupExpressions = new RejectExpressionValuesTransformer(DiscoveryGroupDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        TransformersSubRegistration discoveryGroup = server.registerSubResource(DiscoveryGroupDefinition.PATH);
        discoveryGroup.registerOperationTransformer("add", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{rejectDiscoveryGroupExpressions, discardDiscoveryGroupUndefinedAttributes}));
        discoveryGroup.registerOperationTransformer("write-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{rejectDiscoveryGroupExpressions.getWriteAttributeTransformer(), discardDiscoveryGroupUndefinedAttributes.getWriteAttributeTransformer()}));
        discoveryGroup.registerOperationTransformer("undefine-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{discardDiscoveryGroupUndefinedAttributes.getUndefineAttributeTransformer()}));
        MessagingTransformers.rejectExpressions(server, DivertDefinition.PATH, DivertDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        MessagingTransformers.rejectExpressions(server, BridgeDefinition.PATH, BridgeDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        MessagingTransformers.rejectExpressions(server, QueueDefinition.PATH, QueueDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        for (String path : new String[]{"acceptor", "connector"}) {
            transport = server.registerSubResource(PathElement.pathElement((String)path));
            MessagingTransformers.rejectExpressions(transport, TransportParamDefinition.PATH, TransportParamDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        }
        for (String path : new String[]{"in-vm-acceptor", "in-vm-connector"}) {
            transport = MessagingTransformers.rejectExpressions(server, PathElement.pathElement((String)path), InVMTransportDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
            MessagingTransformers.rejectExpressions(transport, TransportParamDefinition.PATH, TransportParamDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        }
        for (String path : new String[]{"remote-acceptor", "remote-connector"}) {
            transport = server.registerSubResource(PathElement.pathElement((String)path));
            MessagingTransformers.rejectExpressions(transport, TransportParamDefinition.PATH, TransportParamDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        }
        for (String path : MessagingPathHandlers.PATHS.keySet()) {
            MessagingTransformers.rejectExpressions(server, PathElement.pathElement((String)"path", (String)path), "path");
        }
        RejectExpressionValuesTransformer rejectClusterConnectionExpressions = new RejectExpressionValuesTransformer(ClusterConnectionDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        DiscardUndefinedAttributesTransformer discardClusterConnectionUndefinedAttributes = new DiscardUndefinedAttributesTransformer(ClusterConnectionDefinition.NEW_ATTRIBUTES_ADDED_AFTER_1_1_0);
        TransformersSubRegistration clusterConnection = server.registerSubResource(ClusterConnectionDefinition.PATH, (ResourceTransformer)rejectClusterConnectionExpressions, (OperationTransformer)rejectClusterConnectionExpressions);
        clusterConnection.registerOperationTransformer("add", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{rejectClusterConnectionExpressions, discardClusterConnectionUndefinedAttributes}));
        clusterConnection.registerOperationTransformer("write-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{rejectClusterConnectionExpressions.getWriteAttributeTransformer(), discardClusterConnectionUndefinedAttributes.getWriteAttributeTransformer()}));
        clusterConnection.registerOperationTransformer("undefine-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{discardClusterConnectionUndefinedAttributes.getUndefineAttributeTransformer()}));
        TransformersSubRegistration connectorService = server.registerSubResource(ConnectorServiceDefinition.PATH);
        MessagingTransformers.rejectExpressions(connectorService, ConnectorServiceParamDefinition.PATH, "value");
        RejectExpressionValuesTransformer rejectConnectionFactoryExpressions = new RejectExpressionValuesTransformer(ConnectionFactoryDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        DiscardUndefinedAttributesTransformer discardConnectionFactoryUndefinedAttributes = new DiscardUndefinedAttributesTransformer(ConnectionFactoryDefinition.NEW_ATTRIBUTES_ADDED_AFTER_1_1_0);
        TransformersSubRegistration connectionFactory = server.registerSubResource(ConnectionFactoryDefinition.PATH, (ResourceTransformer)rejectConnectionFactoryExpressions, (OperationTransformer)rejectConnectionFactoryExpressions);
        connectionFactory.registerOperationTransformer("add", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{rejectConnectionFactoryExpressions, discardConnectionFactoryUndefinedAttributes}));
        connectionFactory.registerOperationTransformer("write-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{rejectConnectionFactoryExpressions.getWriteAttributeTransformer(), discardConnectionFactoryUndefinedAttributes.getWriteAttributeTransformer()}));
        connectionFactory.registerOperationTransformer("undefine-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{discardConnectionFactoryUndefinedAttributes.getUndefineAttributeTransformer()}));
        RejectExpressionValuesTransformer rejectPooledConnectionFactoryExpressions = new RejectExpressionValuesTransformer(PooledConnectionFactoryDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        DiscardUndefinedAttributesTransformer discardUndefinedPooledConnectionFactoryAttributes = new DiscardUndefinedAttributesTransformer(PooledConnectionFactoryDefinition.NEW_ATTRIBUTES_ADDED_AFTER_1_1_0);
        TransformersSubRegistration pooledConnectionFactory = server.registerSubResource(PooledConnectionFactoryDefinition.PATH);
        pooledConnectionFactory.registerOperationTransformer("add", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{new OperationTransformers.InsertDefaultValuesOperationTransformer(ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS), rejectConnectionFactoryExpressions, discardUndefinedPooledConnectionFactoryAttributes}));
        pooledConnectionFactory.registerOperationTransformer("write-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{rejectPooledConnectionFactoryExpressions.getWriteAttributeTransformer(), discardUndefinedPooledConnectionFactoryAttributes.getWriteAttributeTransformer()}));
        pooledConnectionFactory.registerOperationTransformer("undefine-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{discardUndefinedPooledConnectionFactoryAttributes.getUndefineAttributeTransformer()}));
        MessagingTransformers.rejectExpressions(server, GroupingHandlerDefinition.PATH, GroupingHandlerDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        MessagingTransformers.rejectExpressions(server, JMSQueueDefinition.PATH, JMSQueueDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        MessagingTransformers.rejectExpressions(server, JMSTopicDefinition.PATH, JMSTopicDefinition.ATTRIBUTES_WITH_EXPRESSION_AFTER_1_1_0);
        transformers.registerSubResource(JMSBridgeDefinition.PATH, true);
    }

    private static TransformersSubRegistration rejectExpressions(TransformersSubRegistration parent, PathElement path, AttributeDefinition ... attributes) {
        String[] names = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            AttributeDefinition def = attributes[i];
            names[i] = def.getName();
        }
        return MessagingTransformers.rejectExpressions(parent, path, names);
    }

    private static TransformersSubRegistration rejectExpressions(TransformersSubRegistration parent, PathElement path, String ... attributes) {
        RejectExpressionValuesTransformer rejectExpressions = new RejectExpressionValuesTransformer(attributes);
        TransformersSubRegistration resource = parent.registerSubResource(path, (ResourceTransformer)rejectExpressions, (OperationTransformer)rejectExpressions);
        resource.registerOperationTransformer("add", (OperationTransformer)rejectExpressions);
        resource.registerOperationTransformer("write-attribute", rejectExpressions.getWriteAttributeTransformer());
        return resource;
    }
}

