/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.dmr.ModelNode;

public final class AlternativeAttributeCheckHandler
implements OperationStepHandler {
    private final Map<String, AttributeDefinition> attributeDefinitions = new HashMap<String, AttributeDefinition>();

    public AlternativeAttributeCheckHandler(AttributeDefinition ... definitions) {
        for (AttributeDefinition def : definitions) {
            this.attributeDefinitions.put(def.getName(), def);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource;
        AttributeDefinition attr;
        String attributeName = operation.get("name").asString();
        if (this.attributeDefinitions.containsKey(attributeName) && (attr = this.attributeDefinitions.get(attributeName)).hasAlternative((resource = context.readResource(PathAddress.EMPTY_ADDRESS)).getModel())) {
            context.setRollbackOnly();
            throw new OperationFailedException(new ModelNode().set(MessagingMessages.MESSAGES.altAttributeAlreadyDefined(attributeName)));
        }
        context.stepCompleted();
    }

    public static void checkAlternatives(ModelNode operation, String attr1, String attr2, boolean acceptNone) throws OperationFailedException {
        boolean hasAttr1 = operation.hasDefined(attr1);
        boolean hasAttr2 = operation.hasDefined(attr2);
        if (!(hasAttr1 || hasAttr2 || acceptNone)) {
            throw new OperationFailedException(new ModelNode().set(MessagingMessages.MESSAGES.invalidOperationParameters(attr1, attr2)));
        }
        if (hasAttr1 && hasAttr2) {
            throw new OperationFailedException(new ModelNode().set(MessagingMessages.MESSAGES.cannotIncludeOperationParameters(attr1, attr2)));
        }
    }
}

