/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote.configuration.as;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.as.OutboundSocketBinding;
import org.infinispan.configuration.as.ParserAS7;
import org.infinispan.configuration.as.ParserContextAS7;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserContext;
import org.infinispan.configuration.parsing.ParserContextListener;
import org.infinispan.loaders.remote.configuration.RemoteCacheStoreConfigurationBuilder;
import org.infinispan.loaders.remote.configuration.RemoteServerConfigurationBuilder;
import org.infinispan.loaders.remote.configuration.as.Attribute;
import org.infinispan.loaders.remote.configuration.as.Element;
import org.infinispan.util.StringPropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class RemoteCacheStoreConfigurationParserAS7
implements ConfigurationParser<ConfigurationBuilderHolder> {
    private static final Namespace[] NAMESPACES = new Namespace[]{new Namespace("urn:jboss:domain:infinispan", Element.REMOTE_STORE.getLocalName(), 1, 4), new Namespace("urn:jboss:domain:infinispan", Element.REMOTE_STORE.getLocalName(), 1, 3)};

    public Namespace[] getSupportedNamespaces() {
        return NAMESPACES;
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case REMOTE_STORE: {
                this.parseRemoteStore(reader, holder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseRemoteStore(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParserContextAS7 context = (ParserContextAS7)holder.getParserContext(ParserAS7.class);
        LoadersConfigurationBuilder loaders = holder.getCurrentConfigurationBuilder().loaders();
        RemoteCacheStoreConfigurationBuilder builder = new RemoteCacheStoreConfigurationBuilder(loaders);
        this.parseRemoteStoreAttributes(reader, builder);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SERVER: {
                    this.parseServer(reader, builder.addServer(), context);
                    continue block3;
                }
            }
            ParserAS7.parseStoreElement((XMLExtendedStreamReader)reader, (CacheStoreConfigurationBuilder)builder);
        }
        loaders.addStore((CacheStoreConfigurationBuilder)builder);
    }

    private void parseServer(XMLExtendedStreamReader reader, final RemoteServerConfigurationBuilder builder, ParserContextAS7 context) throws XMLStreamException {
        final String value = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (String)Attribute.OUTBOUND_SOCKET_BINDING.getLocalName());
        context.addParsingCompleteListener(new ParserContextListener(){

            public void parsingComplete(ParserContext context) {
                ParserContextAS7 ctx = (ParserContextAS7)context;
                OutboundSocketBinding binding = ctx.getOutboundSocketBinding(value);
                builder.host(binding.host()).port(binding.port());
            }
        });
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseRemoteStoreAttributes(XMLExtendedStreamReader reader, RemoteCacheStoreConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE: {
                    builder.remoteCacheName(value);
                    continue block5;
                }
                case SOCKET_TIMEOUT: {
                    builder.socketTimeout(Long.parseLong(value));
                    continue block5;
                }
                case TCP_NO_DELAY: {
                    builder.tcpNoDelay(Boolean.parseBoolean(value));
                    continue block5;
                }
                default: {
                    ParserAS7.parseStoreAttribute((XMLExtendedStreamReader)reader, (int)i, (CacheStoreConfigurationBuilder)builder);
                }
            }
        }
    }
}

