/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.configuration.BuiltBy;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.cache.LegacyLoaderAdapter;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.remote.RemoteCacheStoreConfig;
import org.infinispan.loaders.remote.configuration.ConnectionPoolConfiguration;
import org.infinispan.loaders.remote.configuration.ExecutorFactoryConfiguration;
import org.infinispan.loaders.remote.configuration.RemoteCacheStoreConfigurationBuilder;
import org.infinispan.loaders.remote.configuration.RemoteServerConfiguration;
import org.infinispan.loaders.remote.wrapper.EntryWrapper;
import org.infinispan.util.TypedProperties;

@BuiltBy(value=RemoteCacheStoreConfigurationBuilder.class)
public class RemoteCacheStoreConfiguration
extends AbstractStoreConfiguration
implements LegacyLoaderAdapter<RemoteCacheStoreConfig> {
    private final ExecutorFactoryConfiguration asyncExecutorFactory;
    private final String balancingStrategy;
    private final ConnectionPoolConfiguration connectionPool;
    private final long connectionTimeout;
    private final EntryWrapper<?, ?> entryWrapper;
    private final boolean forceReturnValues;
    private final boolean hotRodWrapping;
    private final int keySizeEstimate;
    private final String marshaller;
    private final boolean pingOnStartup;
    private final String protocolVersion;
    private final boolean rawValues;
    private final String remoteCacheName;
    private final List<RemoteServerConfiguration> servers;
    private final long socketTimeout;
    private final boolean tcpNoDelay;
    private final String transportFactory;
    private final int valueSizeEstimate;

    RemoteCacheStoreConfiguration(ExecutorFactoryConfiguration asyncExecutorFactory, String balancingStrategy, ConnectionPoolConfiguration connectionPool, long connectionTimeout, EntryWrapper<?, ?> entryWrapper, boolean forceReturnValues, boolean hotRodWrapping, int keySizeEstimate, String marshaller, boolean pingOnStartup, String protocolVersion, boolean rawValues, String remoteCacheName, List<RemoteServerConfiguration> servers, long socketTimeout, boolean tcpNoDelay, String transportFactory, int valueSizeEstimate, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration asyncStoreConfiguration, SingletonStoreConfiguration singletonStoreConfiguration) {
        super(purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, asyncStoreConfiguration, singletonStoreConfiguration);
        this.asyncExecutorFactory = asyncExecutorFactory;
        this.balancingStrategy = balancingStrategy;
        this.connectionPool = connectionPool;
        this.connectionTimeout = connectionTimeout;
        this.entryWrapper = entryWrapper;
        this.forceReturnValues = forceReturnValues;
        this.hotRodWrapping = hotRodWrapping;
        this.keySizeEstimate = keySizeEstimate;
        this.marshaller = marshaller;
        this.pingOnStartup = pingOnStartup;
        this.protocolVersion = protocolVersion;
        this.rawValues = rawValues;
        this.remoteCacheName = remoteCacheName;
        this.servers = Collections.unmodifiableList(servers);
        this.socketTimeout = socketTimeout;
        this.tcpNoDelay = tcpNoDelay;
        this.transportFactory = transportFactory;
        this.valueSizeEstimate = valueSizeEstimate;
    }

    public ExecutorFactoryConfiguration asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    public String balancingStrategy() {
        return this.balancingStrategy;
    }

    public ConnectionPoolConfiguration connectionPool() {
        return this.connectionPool;
    }

    public long connectionTimeout() {
        return this.connectionTimeout;
    }

    public EntryWrapper<?, ?> entryWrapper() {
        return this.entryWrapper;
    }

    public boolean forceReturnValues() {
        return this.forceReturnValues;
    }

    public boolean hotRodWrapping() {
        return this.hotRodWrapping;
    }

    public int keySizeEstimate() {
        return this.keySizeEstimate;
    }

    public String marshaller() {
        return this.marshaller;
    }

    public boolean pingOnStartup() {
        return this.pingOnStartup;
    }

    public String protocolVersion() {
        return this.protocolVersion;
    }

    public boolean rawValues() {
        return this.rawValues;
    }

    public String remoteCacheName() {
        return this.remoteCacheName;
    }

    public List<RemoteServerConfiguration> servers() {
        return this.servers;
    }

    public long socketTimeout() {
        return this.socketTimeout;
    }

    public boolean tcpNoDelay() {
        return this.tcpNoDelay;
    }

    public String transportFactory() {
        return this.transportFactory;
    }

    public int valueSizeEstimate() {
        return this.valueSizeEstimate;
    }

    public RemoteCacheStoreConfig adapt() {
        RemoteCacheStoreConfig config = new RemoteCacheStoreConfig();
        LegacyConfigurationAdaptor.adapt((CacheStoreConfiguration)this, (CacheStoreConfig)config);
        config.setRawValues(this.rawValues);
        config.setHotRodWrapping(this.hotRodWrapping);
        config.setRemoteCacheName(this.remoteCacheName);
        config.setAsyncExecutorFactory(this.asyncExecutorFactory.factory());
        if (this.entryWrapper != null) {
            config.setEntryWrapper(this.entryWrapper);
        }
        TypedProperties p = new TypedProperties();
        p.putAll((Map)this.asyncExecutorFactory.properties());
        p.put((Object)"maxActive", (Object)Integer.toString(this.connectionPool.maxActive()));
        p.put((Object)"maxIdle", (Object)Integer.toString(this.connectionPool.maxIdle()));
        p.put((Object)"maxTotal", (Object)Integer.toString(this.connectionPool.maxTotal()));
        p.put((Object)"minIdle", (Object)this.connectionPool.minIdle());
        p.put((Object)"minEvictableIdleTimeMillis", (Object)Long.toString(this.connectionPool.minEvictableIdleTime()));
        p.put((Object)"testWhileIdle", (Object)Boolean.toString(this.connectionPool.testWhileIdle()));
        p.put((Object)"timeBetweenEvictionRunsMillis", (Object)Long.toString(this.connectionPool.timeBetweenEvictionRuns()));
        p.put((Object)"whenExhaustedAction", (Object)Integer.toString(this.connectionPool.exhaustedAction().ordinal()));
        config.setTypedProperties(p);
        Properties hrp = new Properties();
        hrp.put("infinispan.client.hotrod.connect_timeout", Long.toString(this.connectionTimeout));
        hrp.put("infinispan.client.hotrod.force_return_values", Boolean.toString(this.forceReturnValues));
        hrp.put("infinispan.client.hotrod.key_size_estimate", Integer.toString(this.keySizeEstimate));
        hrp.put("infinispan.client.hotrod.ping_on_startup", Boolean.toString(this.pingOnStartup));
        StringBuilder serverList = new StringBuilder();
        for (RemoteServerConfiguration server : this.servers) {
            if (serverList.length() > 0) {
                serverList.append(";");
            }
            serverList.append(server.host());
            serverList.append(":");
            serverList.append(server.port());
        }
        hrp.put("infinispan.client.hotrod.server_list", serverList.toString());
        hrp.put("infinispan.client.hotrod.socket_timeout", Long.toString(this.socketTimeout));
        hrp.put("infinispan.client.hotrod.tcp_no_delay", Boolean.toString(this.tcpNoDelay));
        hrp.put("infinispan.client.hotrod.value_size_estimate", Integer.toString(this.valueSizeEstimate));
        if (this.marshaller != null) {
            hrp.put("infinispan.client.hotrod.marshaller", this.marshaller);
        }
        if (this.transportFactory != null) {
            hrp.put("infinispan.client.hotrod.transport_factory", this.transportFactory);
        }
        config.setHotRodClientProperties(hrp);
        return config;
    }
}

