/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.util.LoggerUtil;

public class POSIXTerminal
implements Terminal {
    private int height = -1;
    private int width = -1;
    private boolean echoEnabled;
    private String ttyConfig;
    private String ttyProps;
    private long ttyPropsLastFetched;
    private boolean restored = false;
    private InputStream input;
    private Writer stdOut;
    private Writer stdErr;
    private static long TIMEOUT_PERIOD = 2000L;
    private static final Logger logger = LoggerUtil.getLogger(POSIXTerminal.class.getName());

    @Override
    public void init(InputStream inputStream, OutputStream stdOut, OutputStream stdErr) {
        try {
            this.ttyConfig = POSIXTerminal.stty("-g");
            if (this.ttyConfig.length() == 0 || !this.ttyConfig.contains("=") && !this.ttyConfig.contains(":")) {
                if (Settings.getInstance().isLogging()) {
                    logger.log(Level.SEVERE, "Unrecognized stty code: " + this.ttyConfig);
                }
                throw new RuntimeException("Unrecognized stty code: " + this.ttyConfig);
            }
            POSIXTerminal.stty("-ixon -icanon min 1");
            POSIXTerminal.stty("-echo");
            this.echoEnabled = false;
            this.input = inputStream;
        }
        catch (IOException ioe) {
            if (Settings.getInstance().isLogging()) {
                logger.log(Level.SEVERE, "tty failed: ", ioe);
            }
        }
        catch (InterruptedException e) {
            if (Settings.getInstance().isLogging()) {
                logger.log(Level.SEVERE, "failed while waiting for process to end: ", e);
            }
            e.printStackTrace();
        }
        this.stdOut = new PrintWriter(new OutputStreamWriter(stdOut));
        this.stdErr = new PrintWriter(new OutputStreamWriter(stdErr));
    }

    @Override
    public int[] read(boolean readAhead) throws IOException {
        int input = this.input.read();
        int available = this.input.available();
        if (available > 1 && readAhead) {
            int[] in = new int[available];
            in[0] = input;
            for (int c = 1; c < available; ++c) {
                in[c] = this.input.read();
            }
            return in;
        }
        return new int[]{input};
    }

    @Override
    public void writeToStdOut(String out) throws IOException {
        if (out != null && out.length() > 0) {
            this.stdOut.write(out);
            this.stdOut.flush();
        }
    }

    @Override
    public void writeToStdOut(char[] out) throws IOException {
        if (out != null && out.length > 0) {
            this.stdOut.write(out);
            this.stdOut.flush();
        }
    }

    @Override
    public void writeToStdOut(char out) throws IOException {
        this.stdOut.write(out);
        this.stdOut.flush();
    }

    @Override
    public void writeToStdErr(String err) throws IOException {
        if (err != null && err.length() > 0) {
            this.stdErr.write(err);
            this.stdErr.flush();
        }
    }

    @Override
    public void writeToStdErr(char[] err) throws IOException {
        if (err != null && err.length > 0) {
            this.stdErr.write(err);
            this.stdErr.flush();
        }
    }

    @Override
    public void writeToStdErr(char err) throws IOException {
        this.stdErr.write(err);
        this.stdErr.flush();
    }

    @Override
    public int getHeight() {
        block4: {
            if (this.height < 1 || this.propertiesTimedOut()) {
                try {
                    this.height = this.getTerminalProperty("rows");
                }
                catch (Exception e) {
                    if (!Settings.getInstance().isLogging()) break block4;
                    logger.log(Level.SEVERE, "Failed to fetch terminal height: ", e);
                }
            }
        }
        if (this.height < 1) {
            this.height = 24;
        }
        return this.height;
    }

    @Override
    public int getWidth() {
        block4: {
            if (this.width < 1 || this.propertiesTimedOut()) {
                try {
                    this.width = this.getTerminalProperty("columns");
                }
                catch (Exception e) {
                    if (!Settings.getInstance().isLogging()) break block4;
                    logger.log(Level.SEVERE, "Failed to fetch terminal width: ", e);
                }
            }
        }
        if (this.width < 1) {
            this.width = 80;
        }
        return this.width;
    }

    @Override
    public boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    @Override
    public void reset() throws IOException {
        block3: {
            if (!this.restored && this.ttyConfig != null) {
                try {
                    POSIXTerminal.stty(this.ttyConfig);
                    this.ttyConfig = null;
                    this.restored = true;
                }
                catch (InterruptedException e) {
                    if (!Settings.getInstance().isLogging()) break block3;
                    logger.log(Level.SEVERE, "Failed to reset terminal: ", e);
                }
            }
        }
    }

    private boolean propertiesTimedOut() {
        return System.currentTimeMillis() - this.ttyPropsLastFetched > TIMEOUT_PERIOD;
    }

    private int getTerminalProperty(String prop) throws IOException, InterruptedException {
        if (this.ttyProps == null || this.propertiesTimedOut()) {
            this.ttyProps = POSIXTerminal.stty("-a");
            this.ttyPropsLastFetched = System.currentTimeMillis();
        }
        for (String str : this.ttyProps.split(";")) {
            if ((str = str.trim()).startsWith(prop)) {
                int index = str.lastIndexOf(" ");
                return Integer.parseInt(str.substring(index).trim());
            }
            if (!str.endsWith(prop)) continue;
            int index = str.indexOf(" ");
            return Integer.parseInt(str.substring(0, index).trim());
        }
        return -1;
    }

    protected static String stty(String args) throws IOException, InterruptedException {
        return POSIXTerminal.exec("stty " + args + " < /dev/tty").trim();
    }

    private static String exec(String cmd) throws IOException, InterruptedException {
        return POSIXTerminal.exec(new String[]{"sh", "-c", cmd});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String exec(String[] cmd) throws IOException, InterruptedException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream in = null;
        InputStream err = null;
        OutputStream out = null;
        try {
            int c;
            in = p.getInputStream();
            while ((c = in.read()) != -1) {
                bout.write(c);
            }
            err = p.getErrorStream();
            while ((c = err.read()) != -1) {
                bout.write(c);
            }
            out = p.getOutputStream();
            p.waitFor();
        }
        finally {
            block13: {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (err != null) {
                        err.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    if (!Settings.getInstance().isLogging()) break block13;
                    logger.log(Level.SEVERE, "Failed to close streams: ", e);
                }
            }
        }
        return new String(bout.toByteArray());
    }
}

