/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.net.httpserver.spi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.jboss.com.sun.net.httpserver.HttpServer;
import org.jboss.com.sun.net.httpserver.HttpsServer;
import org.jboss.sun.net.httpserver.DefaultHttpServerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpServerProvider {
    private static final Object lock = new Object();
    private static HttpServerProvider provider = null;

    public abstract HttpServer createHttpServer(InetSocketAddress var1, int var2, Map<String, String> var3) throws IOException;

    public abstract HttpsServer createHttpsServer(InetSocketAddress var1, int var2, Map<String, String> var3) throws IOException;

    protected HttpServerProvider() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("httpServerProvider"));
        }
    }

    private static boolean loadProviderFromProperty() {
        String cn = System.getProperty("com.sun.net.httpserver.HttpServerProvider");
        if (cn == null) {
            return false;
        }
        try {
            Class<?> c = Class.forName(cn, true, ClassLoader.getSystemClassLoader());
            provider = (HttpServerProvider)c.newInstance();
            return true;
        }
        catch (ClassNotFoundException x) {
            throw HttpServerProvider.configError(x);
        }
        catch (IllegalAccessException x) {
            throw HttpServerProvider.configError(x);
        }
        catch (InstantiationException x) {
            throw HttpServerProvider.configError(x);
        }
        catch (SecurityException x) {
            throw HttpServerProvider.configError(x);
        }
    }

    private static ServiceConfigurationError configError(Throwable x) {
        ServiceConfigurationError error = new ServiceConfigurationError(x.getMessage());
        error.initCause(x);
        return error;
    }

    private static boolean loadProviderAsService() {
        ServiceLoader<HttpServerProvider> loader = ServiceLoader.load(HttpServerProvider.class, null);
        Iterator<HttpServerProvider> i = loader.iterator();
        while (i.hasNext()) {
            try {
                provider = i.next();
                return true;
            }
            catch (ServiceConfigurationError sce) {
                if (sce.getCause() instanceof SecurityException) continue;
                throw sce;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpServerProvider provider() {
        Object object = lock;
        synchronized (object) {
            if (provider != null) {
                return provider;
            }
            return (HttpServerProvider)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (HttpServerProvider.loadProviderFromProperty()) {
                        return provider;
                    }
                    if (HttpServerProvider.loadProviderAsService()) {
                        return provider;
                    }
                    provider = (HttpServerProvider)new DefaultHttpServerProvider();
                    return provider;
                }
            });
        }
    }
}

