/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.util.Date;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;

public class Time {
    public static final long UNIX_OFFSET = 122192928000000000L;

    private Time() {
    }

    public static UtcT corbaTime() {
        return Time.corbaTime(System.currentTimeMillis());
    }

    public static UtcT corbaTime(long unixTime) {
        UtcT result = new UtcT();
        result.time = unixTime * 10000L + 122192928000000000L;
        result.tdf = 0;
        result.inacchi = 0;
        result.inacclo = 0;
        return result;
    }

    public static UtcT corbaTime(Date date) {
        return Time.corbaTime(date.getTime());
    }

    public static UtcT corbaFuture(long corbaUnits) {
        if (corbaUnits < 0L) {
            return null;
        }
        UtcT result = Time.corbaTime();
        result.time += corbaUnits;
        return result;
    }

    public static long millisTo(UtcT time) {
        long unixTime = (time.time - 122192928000000000L) / 10000L;
        if (time.tdf != 0) {
            unixTime -= (long)(time.tdf * 60000);
        }
        return unixTime - System.currentTimeMillis();
    }

    public static boolean hasPassed(UtcT time) {
        if (time != null) {
            return Time.millisTo(time) < 0L;
        }
        return false;
    }

    public static UtcT earliest(UtcT timeA, UtcT timeB) {
        if (timeA == null) {
            if (timeB == null) {
                return null;
            }
            return timeB;
        }
        if (timeB == null || timeA.time <= timeB.time) {
            return timeA;
        }
        return timeB;
    }

    public static byte[] toCDR(UtcT time) {
        byte[] buffer = new byte[25];
        CDROutputStream out = new CDROutputStream(buffer);
        out.beginEncapsulatedArray();
        UtcTHelper.write(out, time);
        return out.getBufferCopy();
    }

    public static UtcT fromCDR(byte[] buffer) {
        CDRInputStream in = new CDRInputStream(null, buffer);
        in.openEncapsulatedArray();
        return UtcTHelper.read(in);
    }

    public static void waitFor(UtcT time) {
        if (time != null) {
            long now = System.currentTimeMillis();
            long delta = Time.millisTo(time);
            long then = now + delta;
            while (delta > 0L) {
                try {
                    Thread.sleep(delta);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                delta = then - System.currentTimeMillis();
            }
        }
    }
}

