/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.ArrayList;
import java.util.List;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.Schedulable;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.interfaces.FilterStage;

public class FilterConsumerAdminTask
extends AbstractFilterTask {
    private static int sCount = 0;
    private final int id_ = ++sCount;
    private final List listOfFilterStageWithMessageConsumer_ = new ArrayList();

    public FilterConsumerAdminTask(TaskFactory taskFactory, TaskExecutor taskExecutor) {
        super(taskFactory, taskExecutor);
    }

    public String toString() {
        return "[FilterConsumerAdminTask#" + this.id_ + "]";
    }

    public FilterStage[] getFilterStagesWithMessageConsumer() {
        return this.listOfFilterStageWithMessageConsumer_.toArray(EMPTY_FILTERSTAGE);
    }

    private void clearFilterStagesWithMessageConsumer() {
        this.listOfFilterStageWithMessageConsumer_.clear();
    }

    public void reset() {
        super.reset();
        this.clearFilterStagesWithMessageConsumer();
        this.arrayCurrentFilterStage_ = EMPTY_FILTERSTAGE;
    }

    public void doFilter() throws InterruptedException {
        this.filter();
        this.pushToConsumers();
    }

    private void pushToConsumers() {
        FilterStage[] _filterStagesWithMessageConsumer = this.getFilterStagesWithMessageConsumer();
        if (_filterStagesWithMessageConsumer.length > 0) {
            this.getTaskFactory().enqueueMessage(_filterStagesWithMessageConsumer, this.getMessage());
        }
        Schedulable _filterTaskToBeScheduled = this.getTaskFactory().newFilterProxySupplierTask(this);
        _filterTaskToBeScheduled.schedule();
    }

    private void filter() throws InterruptedException {
        for (int x = 0; x < this.arrayCurrentFilterStage_.length; ++x) {
            this.checkInterrupt();
            boolean _filterForCurrentFilterStageMatched = false;
            if (!this.arrayCurrentFilterStage_[x].isDestroyed()) {
                _filterForCurrentFilterStageMatched = this.getMessage().match(this.arrayCurrentFilterStage_[x]);
            }
            if (_filterForCurrentFilterStageMatched) {
                if (this.arrayCurrentFilterStage_[x].hasInterFilterGroupOperatorOR()) {
                    this.listOfFilterStageWithMessageConsumer_.addAll(this.arrayCurrentFilterStage_[x].getSubsequentFilterStages());
                    continue;
                }
                this.addFilterStage(this.arrayCurrentFilterStage_[x].getSubsequentFilterStages());
                continue;
            }
            for (FilterStage _filterStage : this.arrayCurrentFilterStage_[x].getSubsequentFilterStages()) {
                if (!_filterStage.hasInterFilterGroupOperatorOR()) continue;
                this.addFilterStage(_filterStage);
            }
        }
    }
}

