/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jacorb.config.Configuration;
import org.jacorb.imr.Admin;
import org.jacorb.imr.AdminHelper;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.Registration;
import org.jacorb.imr.RegistrationHelper;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.UnknownServerName;
import org.jacorb.orb.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.slf4j.Logger;

public class ImRManager {
    private static ORB m_orb;
    private static Logger logger;

    public static void autoRegisterServer(org.omg.CORBA.ORB orb, String server, String command, String host, boolean edit_existing) {
        try {
            Admin admin = AdminHelper.narrow(orb.resolve_initial_references("ImplementationRepository"));
            Configuration config = ((ORB)orb).getConfiguration();
            Logger logger = config.getLogger("jacorb.imr.manager");
            ServerInfo info = null;
            try {
                info = admin.get_server_info(server);
            }
            catch (UnknownServerName n) {
                logger.warn("Unknown Server name", (Throwable)n);
            }
            if (info == null) {
                admin.register_server(server, command, host);
            } else if (info != null && edit_existing) {
                admin.edit_server(server, command, host);
            }
        }
        catch (Exception e) {
            logger.warn("unexpected exception", (Throwable)e);
        }
    }

    public static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
    }

    public static String getAnyHostName(org.omg.CORBA.ORB orb) {
        try {
            Admin admin = AdminHelper.narrow(orb.resolve_initial_references("ImplementationRepository"));
            HostInfo[] hosts = admin.list_hosts();
            if (hosts.length > 0) {
                return hosts[0].name;
            }
        }
        catch (Exception e) {
            logger.warn("unexpected exception", (Throwable)e);
        }
        return "";
    }

    private static Admin getAdmin() {
        Admin _admin;
        block3: {
            _admin = null;
            try {
                _admin = AdminHelper.narrow(m_orb.resolve_initial_references("ImplementationRepository"));
            }
            catch (InvalidName in) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("Could not contact Impl. Repository!");
            }
        }
        if (_admin == null) {
            System.out.println("Unable to connect to repository process!");
            System.exit(-1);
        }
        return _admin;
    }

    private static void addServer(String[] args) {
        if (args.length == 1) {
            System.out.println("Please specify at least server name");
            ImRManager.shortUsage();
        }
        String _server_name = args[1];
        String _host = null;
        String _command = null;
        try {
            for (int i = 2; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    if (++i < args.length) {
                        _host = args[i];
                        continue;
                    }
                    System.out.println("Please provide a hostname after the -h switch");
                    ImRManager.shortUsage();
                    continue;
                }
                if (args[i].equals("-c")) {
                    StringBuffer sb = new StringBuffer();
                    for (int j = i + 1; j < args.length; ++j) {
                        sb.append(args[j]);
                        if (j >= args.length - 1) continue;
                        sb.append(' ');
                    }
                    _command = sb.toString();
                    break;
                }
                System.out.println("Unrecognized switch: " + args[i]);
                ImRManager.shortUsage();
            }
            if (_host == null) {
                _host = ImRManager.getLocalHostName();
            }
        }
        catch (Exception _e) {
            _e.printStackTrace();
            ImRManager.usage();
        }
        if (_command == null) {
            _command = "";
        }
        Admin _admin = ImRManager.getAdmin();
        try {
            if (args[0].equals("add")) {
                _admin.register_server(_server_name, _command, _host);
            } else {
                _admin.edit_server(_server_name, _command, _host);
            }
            System.out.println("Server " + _server_name + " successfully " + args[0] + "ed");
            System.out.println("Host: >>" + _host + "<<");
            if (_command.length() > 0) {
                System.out.println("Command: >>" + _command + "<<");
            } else {
                System.out.println("No command specified. Server can't be restarted!");
            }
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        System.exit(0);
    }

    private static void remove(String[] args) {
        if (args.length == 1) {
            System.out.println(" Please specify if you want to remove a server or a host");
            ImRManager.shortUsage();
        }
        if (args.length == 2) {
            System.out.println(" Please specify a servername / hostname");
            ImRManager.shortUsage();
        }
        Admin _admin = ImRManager.getAdmin();
        if (args[1].equals("server")) {
            try {
                _admin.unregister_server(args[2]);
                System.out.println("Server " + args[2] + " successfully removed");
            }
            catch (Exception _e) {
                _e.printStackTrace();
            }
        } else if (args[1].equals("host")) {
            try {
                _admin.unregister_host(args[2]);
                System.out.println("Host " + args[2] + " successfully removed");
            }
            catch (Exception _e) {
                _e.printStackTrace();
            }
        } else {
            System.out.println("Unknown command " + args[1]);
            ImRManager.shortUsage();
        }
        System.exit(0);
    }

    private static void list(String[] args) {
        if (args.length == 1) {
            System.out.println("Please use (servers | hosts) in command");
            ImRManager.shortUsage();
        }
        Admin _admin = ImRManager.getAdmin();
        try {
            if (args[1].equals("servers")) {
                ServerInfo[] _info = _admin.list_servers();
                System.out.println("Servers (total: " + _info.length + "):");
                for (int _i = 0; _i < _info.length; ++_i) {
                    System.out.println(_i + 1 + ") " + _info[_i].name);
                    System.out.println("   Host: " + _info[_i].host);
                    System.out.println("   Command: " + _info[_i].command);
                    System.out.println("   active: " + (_info[_i].active ? "yes" : "no"));
                    System.out.println("   holding: " + (_info[_i].holding ? "yes" : "no"));
                }
            } else if (args[1].equals("hosts")) {
                HostInfo[] _info = _admin.list_hosts();
                System.out.println("Hosts (total: " + _info.length + "):");
                for (int _i = 0; _i < _info.length; ++_i) {
                    System.out.println(_i + 1 + ") " + _info[_i].name);
                }
            } else {
                System.out.println("Unrecognized option: " + args[1]);
                ImRManager.shortUsage();
            }
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        System.exit(0);
    }

    private static void holdServer(String[] args) {
        if (args.length == 1) {
            System.out.println("Please specify a server name");
            ImRManager.shortUsage();
        }
        String _server_name = args[1];
        int _timeout = 0;
        Admin _admin = ImRManager.getAdmin();
        try {
            if (args.length == 3) {
                _timeout = Integer.parseInt(args[2]);
            }
            _admin.hold_server(_server_name);
            System.out.println("Server " + _server_name + " set to holding");
            if (_timeout > 0) {
                Thread.sleep(_timeout);
                _admin.release_server(_server_name);
                System.out.println("Server " + _server_name + " released");
            }
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        System.exit(0);
    }

    private static void releaseServer(String[] args) {
        if (args.length == 1) {
            System.out.println("Please specify a server name");
            ImRManager.shortUsage();
        }
        String _server_name = args[1];
        boolean _timeout = false;
        Admin _admin = ImRManager.getAdmin();
        try {
            _admin.release_server(_server_name);
            System.out.println("Server " + _server_name + " released");
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        System.exit(0);
    }

    private static void startServer(String[] args) {
        if (args.length == 1) {
            System.out.println("Please specify a server name");
            ImRManager.shortUsage();
        }
        String _server_name = args[1];
        Admin _admin = ImRManager.getAdmin();
        try {
            _admin.start_server(_server_name);
            System.out.println("Server " + _server_name + " started");
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        System.exit(0);
    }

    private static void saveTable() {
        Admin _admin = ImRManager.getAdmin();
        try {
            _admin.save_server_table();
            System.out.println("Backup of server table was successfull");
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        System.exit(0);
    }

    private static void shutdownImR(String[] args) {
        Admin _admin = ImRManager.getAdmin();
        boolean _wait = true;
        if (args.length == 2) {
            if (args[1].toLowerCase().equals("force")) {
                _wait = false;
            } else {
                System.out.println("Unrecognized option: " + args[1]);
                System.out.println("The only possible option is \"force\"");
                ImRManager.shortUsage();
            }
        }
        try {
            _admin.shutdown(_wait);
            System.out.println("The Implementation Repository has been shut down without exceptions");
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        System.exit(0);
    }

    private static void setDown(String[] args) {
        if (args.length == 1) {
            System.out.println("Please specify a server name");
            ImRManager.shortUsage();
        }
        Registration _reg = RegistrationHelper.narrow(ImRManager.getAdmin());
        try {
            _reg.set_server_down(args[1]);
            System.out.println("Server " + args[1] + " set down");
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        System.exit(0);
    }

    private static void shortUsage() {
        System.out.println("\nYour command has not been understood possibly due to\none or more missing arguments");
        System.out.println("Type \"imr_mg help\" to display the help screen");
        System.exit(-1);
    }

    private static void usage() {
        System.out.println("Usage: ImRManager <command> [<servername>] [switches]");
        System.out.println("Command: (add | edit) <servername> [-h <hostname> -c <startup cmd>]");
        System.out.println("\t -h <hostname> Restart server on this host");
        System.out.println("\t -c <command> Restart server with this command");
        System.out.println("\t If -h is not set, the local hosts name (that of the manager) is used.");
        System.out.println("\t Note: The -c switch must always follow after the -h switch,");
        System.out.println("\t because all arguments after -c are interpreted as the");
        System.out.println("\t startup command.");
        System.out.println("\nCommand: remove (server | host) <name>");
        System.out.println("\t Removes the server or host <name> from the repository");
        System.out.println("\nCommand: list (servers | hosts)");
        System.out.println("\t Lists all servers or all hosts");
        System.out.println("\nCommand: hold <servername> [<time>]");
        System.out.println("\t Holds the server <servername> (if <time> is specified,");
        System.out.println("\t it is released automatically)");
        System.out.println("\nCommand: release <servername>");
        System.out.println("\t Releases the server <servername>");
        System.out.println("\nCommand: start <servername>");
        System.out.println("\t Starts the server <servername> on its given host with its given command");
        System.out.println("\nCommand: setdown <servername>");
        System.out.println("\t Declares the server <servername> as \"down\" to the repository.");
        System.out.println("\t This means that the repository tries to start the server up after ");
        System.out.println("\t receiving the next request for it.");
        System.out.println("\t This is actually an operation only committed by the ORB, but it");
        System.out.println("\t might be useful for server migration and recovery of crashed servers.");
        System.out.println("\t Note: Use \"hold\" before, to avoid the server being restarted at the");
        System.out.println("\t wrong moment.");
        System.out.println("\nCommand: savetable");
        System.out.println("\t Makes a backup of the server table");
        System.out.println("\nCommand: shutdown [force]");
        System.out.println("\t Shuts the ImR down orderly. If \"force\" is specified, the ORB ");
        System.out.println("\t is forced down, ignoring open connections.");
        System.out.println("\nCommand: gui");
        System.out.println("\t Bring up manager GUI window");
        System.out.println("\nCommand: help");
        System.out.println("\t This screen");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ImRManager.usage();
        }
        m_orb = (ORB)org.omg.CORBA.ORB.init(args, null);
        logger = m_orb.getConfiguration().getLogger("jacorb.imr.manager");
        try {
            if (args[0].equals("add") || args[0].equals("edit")) {
                ImRManager.addServer(args);
            } else if (args[0].equals("remove")) {
                ImRManager.remove(args);
            } else if (args[0].equals("list")) {
                ImRManager.list(args);
            } else if (args[0].equals("hold")) {
                ImRManager.holdServer(args);
            } else if (args[0].equals("release")) {
                ImRManager.releaseServer(args);
            } else if (args[0].equals("start")) {
                ImRManager.startServer(args);
            } else if (args[0].equals("savetable")) {
                ImRManager.saveTable();
            } else if (args[0].equals("shutdown")) {
                ImRManager.shutdownImR(args);
            } else if (args[0].equals("setdown")) {
                ImRManager.setDown(args);
            } else if (args[0].equals("gui")) {
                Class.forName("org.jacorb.imr.util.ImRManagerGUI").newInstance();
            } else if (args[0].equals("help")) {
                ImRManager.usage();
            } else {
                System.out.println("Unrecognized command: " + args[0]);
                ImRManager.usage();
            }
        }
        catch (Exception _e) {
            _e.printStackTrace();
            System.exit(0);
        }
    }
}

