/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.internal;

import java.util.Collection;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.internal.DeploymentMessages;
import org.jboss.osgi.spi.Attachments;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class InvocationContextImpl
implements InvocationContext {
    private final BundleContext systemContext;
    private Attachments attachments;
    private VirtualFile root;
    private Bundle bundle;

    public InvocationContextImpl(BundleContext systemContext, Bundle bundle2, VirtualFile root, Attachments attachments) {
        if (systemContext == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("context");
        }
        if (bundle2 == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        if (attachments == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("attachments");
        }
        this.systemContext = systemContext;
        this.root = root;
        this.bundle = bundle2;
        this.attachments = attachments;
    }

    @Override
    public BundleContext getSystemContext() {
        return this.systemContext;
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public VirtualFile getRoot() {
        return this.root;
    }

    public <T> T addAttachment(Class<T> clazz, T value) {
        return (T)this.attachments.addAttachment(clazz, value);
    }

    public <T> T addAttachment(String name, T value, Class<T> clazz) {
        return (T)this.attachments.addAttachment(name, value, clazz);
    }

    public Object addAttachment(String name, Object value) {
        return this.attachments.addAttachment(name, value);
    }

    public <T> T getAttachment(String name, Class<T> clazz) {
        return (T)this.attachments.getAttachment(name, clazz);
    }

    public <T> T getAttachment(Class<T> clazz) {
        return (T)this.attachments.getAttachment(clazz);
    }

    public Object getAttachment(String name) {
        return this.attachments.getAttachment(name);
    }

    public Collection<Attachments.Key> getAttachmentKeys() {
        return this.attachments.getAttachmentKeys();
    }

    public <T> T removeAttachment(Class<T> clazz, String name) {
        return (T)this.attachments.removeAttachment(clazz, name);
    }

    public <T> T removeAttachment(Class<T> clazz) {
        return (T)this.attachments.removeAttachment(clazz);
    }

    public Object removeAttachment(String name) {
        return this.attachments.removeAttachment(name);
    }
}

