/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.jboss.as.jdr.JdrLogger;
import org.jboss.as.jdr.commands.JdrEnvironment;
import org.jboss.vfs.VirtualFile;

public class JdrZipFile {
    ZipOutputStream zos;
    String jbossHome;
    JdrEnvironment env;
    String name;
    String baseName;

    public JdrZipFile(JdrEnvironment env) throws Exception {
        this.env = env;
        this.jbossHome = this.env.getJbossHome();
        SimpleDateFormat fmt = new SimpleDateFormat("yy-MM-dd_hh-mm-ss");
        this.baseName = "jdr_" + fmt.format(new Date());
        if (this.env.getHostControllerName() != null) {
            this.baseName = this.baseName + "." + this.env.getHostControllerName();
        }
        if (this.env.getServerName() != null) {
            this.baseName = this.baseName + "_" + this.env.getServerName();
        }
        this.name = this.env.getOutputDirectory() + File.separator + this.baseName + ".zip";
        this.zos = new ZipOutputStream(new FileOutputStream(this.name));
    }

    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(InputStream is, String path) {
        byte[] buffer = new byte[1024];
        try {
            String entryName = this.baseName + "/" + path;
            ZipEntry ze = new ZipEntry(entryName);
            this.zos.putNextEntry(ze);
            int bytesRead = is.read(buffer);
            while (bytesRead > -1) {
                this.zos.write(buffer, 0, bytesRead);
                bytesRead = is.read(buffer);
            }
        }
        catch (ZipException ze) {
            JdrLogger.ROOT_LOGGER.debugf(ze, "%s is already in the zip", path);
        }
        catch (Exception e) {
            JdrLogger.ROOT_LOGGER.debugf(e, "Error when adding %s", path);
        }
        finally {
            try {
                this.zos.closeEntry();
            }
            catch (Exception e) {
                JdrLogger.ROOT_LOGGER.debugf(e, "Error when closing entry for %s", path);
            }
        }
    }

    public void add(VirtualFile file, InputStream is) throws Exception {
        String name = "JBOSS_HOME" + file.getPathName().substring(this.jbossHome.length());
        this.add(is, name);
    }

    public void add(String content, String path) throws Exception {
        String name = "sos_strings/as7/" + path;
        this.add(new ByteArrayInputStream(content.getBytes()), name);
    }

    public void addLog(String content, String logName) throws Exception {
        String name = "sos_logs/" + logName;
        this.add(new ByteArrayInputStream(content.getBytes()), name);
    }

    public void close() throws Exception {
        this.zos.close();
    }
}

