/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Map;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractCapability;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.osgi.service.resolver.HostedCapability;

public class AbstractHostedCapability
extends AbstractElement
implements HostedCapability,
XPackageCapability {
    private final XResource resource;
    private final XCapability capability;

    public AbstractHostedCapability(XResource resource, XCapability capability) {
        if (capability == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("capability");
        }
        this.resource = resource;
        this.capability = capability;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public boolean isMutable() {
        return false;
    }

    @Override
    public Capability getDeclaredCapability() {
        return this.capability;
    }

    @Override
    public String getNamespace() {
        return this.capability.getNamespace();
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.capability.getDirectives();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.capability.getAttributes();
    }

    @Override
    public Object getAttribute(String key) {
        return this.capability.getAttribute(key);
    }

    @Override
    public String getDirective(String key) {
        return this.capability.getDirective(key);
    }

    @Override
    public void validate() {
        this.capability.validate();
    }

    @Override
    public String getPackageName() {
        String result = null;
        if ("osgi.wiring.package".equals(this.getNamespace())) {
            result = (String)this.getAttribute("osgi.wiring.package");
        }
        return result;
    }

    @Override
    public Version getVersion() {
        Version result = null;
        if ("osgi.wiring.host".equals(this.getNamespace())) {
            result = AbstractCapability.getVersion(this.capability, "bundle-version");
        } else if ("osgi.wiring.bundle".equals(this.getNamespace())) {
            result = AbstractCapability.getVersion(this.capability, "bundle-version");
        }
        return result;
    }

    @Override
    public <T extends XCapability> T adapt(Class<T> clazz) {
        AbstractHostedCapability result = null;
        if (XPackageCapability.class == clazz && "osgi.wiring.package".equals(this.getNamespace())) {
            result = this;
        }
        return (T)result;
    }

    public String toString() {
        return "HostedCapability[" + this.resource + "," + this.capability + "]";
    }
}

