/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.BootstrapBundlesActivate;
import org.jboss.osgi.framework.spi.BootstrapBundlesService;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.resolver.ResolutionException;

public class BootstrapBundlesResolve<T>
extends BootstrapBundlesService<T> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<PackageAdmin> injectedPackageAdmin = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<XBundle> injectedSystemBundle = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();
    private final Set<ServiceName> installedServices;

    public BootstrapBundlesResolve(ServiceName baseName, Set<ServiceName> installedServices) {
        super(baseName, IntegrationServices.BootstrapPhase.RESOLVE);
        this.installedServices = installedServices;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<T> builder) {
        builder.addDependency(IntegrationServices.SYSTEM_BUNDLE_INTERNAL, XBundle.class, this.injectedSystemBundle);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(Services.PACKAGE_ADMIN, PackageAdmin.class, this.injectedPackageAdmin);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(Services.RESOLVER, XResolver.class, this.injectedResolver);
        builder.addDependencies(new ServiceName[]{this.getPreviousService()});
    }

    protected BundleManager getBundleManager() {
        return (BundleManager)this.injectedBundleManager.getValue();
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        FrameworkLogger.LOGGER.debugf("Resolve %s bundles on behalf of %s", (Object)this.getBundleType(), this.getServiceName().getCanonicalName());
        ServiceContainer serviceRegistry = context.getController().getServiceContainer();
        int targetLevel = this.getBeginningStartLevel();
        HashMap<ServiceName, XBundle> resolvableServices = new HashMap<ServiceName, XBundle>();
        for (ServiceName installedName : this.installedServices) {
            int bundleLevel;
            XBundle bundle2 = (XBundle)this.getServiceController(serviceRegistry, installedName).getValue();
            Deployment dep = (Deployment)bundle2.adapt(Deployment.class);
            int n = bundleLevel = dep.getStartLevel() != null ? dep.getStartLevel() : 1;
            if (!dep.isAutoStart() || bundle2.isFragment() || bundleLevel > targetLevel) continue;
            ServiceName resolvedName = this.getBundleManager().getServiceName(bundle2, 4);
            resolvableServices.put(resolvedName, bundle2);
        }
        if (this.getBundleType() == BootstrapBundlesService.BundleType.bootstrap) {
            XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
            ArrayList<XBundleRevision> mandatory = new ArrayList<XBundleRevision>();
            mandatory.add(((XBundle)this.injectedSystemBundle.getValue()).getBundleRevision());
            for (XBundle bundle3 : resolvableServices.values()) {
                mandatory.add(bundle3.getBundleRevision());
            }
            XResolver resolver = (XResolver)this.injectedResolver.getValue();
            XResolveContext ctx = resolver.createResolveContext(env, mandatory, null);
            try {
                resolver.resolveAndApply(ctx);
            }
            catch (ResolutionException ex) {
                throw new StartException((Throwable)ex);
            }
        }
        if (!resolvableServices.isEmpty()) {
            if (IntegrationServices.PERSISTENT_BUNDLES.isParentOf(this.getServiceName())) {
                Bundle[] bundles = resolvableServices.values().toArray(new Bundle[resolvableServices.size()]);
                PackageAdmin packageAdmin = (PackageAdmin)this.injectedPackageAdmin.getValue();
                packageAdmin.resolveBundles(bundles);
            }
            for (ServiceName serviceName : new HashSet(resolvableServices.keySet())) {
                if (((XBundle)resolvableServices.get(serviceName)).isResolved()) continue;
                resolvableServices.remove(serviceName);
            }
        }
        this.installActivateService(context.getChildTarget(), resolvableServices.keySet());
    }

    private ServiceController<XBundle> getServiceController(ServiceContainer serviceRegistry, ServiceName serviceName) {
        return serviceRegistry.getRequiredService(serviceName);
    }

    private int getBeginningStartLevel() {
        String levelSpec = (String)this.getBundleManager().getProperty("org.osgi.framework.startlevel.beginning");
        if (levelSpec != null) {
            try {
                return Integer.parseInt(levelSpec);
            }
            catch (NumberFormatException nfe) {
                FrameworkLogger.LOGGER.errorInvalidBeginningStartLevel(levelSpec);
            }
        }
        return 1;
    }

    protected ServiceController<T> installActivateService(ServiceTarget serviceTarget, Set<ServiceName> resolvedServices) {
        return new BootstrapBundlesActivate(this.getServiceName().getParent(), resolvedServices).install(serviceTarget, this.getServiceListener());
    }
}

