/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.util.ArrayList;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.SystemBundleRevision;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleStorage;
import org.jboss.osgi.framework.spi.FrameworkModuleProvider;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.framework.spi.SystemPaths;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

final class SystemBundlePlugin
extends AbstractIntegrationService<SystemBundleState> {
    private final FrameworkState frameworkState;
    private SystemBundleState bundleState;

    SystemBundlePlugin(FrameworkState frameworkState) {
        super(IntegrationServices.SYSTEM_BUNDLE_INTERNAL);
        this.frameworkState = frameworkState;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<SystemBundleState> builder) {
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.frameworkState.injectedEnvironment);
        builder.addDependency(IntegrationServices.BUNDLE_STORAGE, BundleStorage.class, this.frameworkState.injectedBundleStorage);
        builder.addDependency(IntegrationServices.FRAMEWORK_MODULE_PROVIDER, FrameworkModuleProvider.class, this.frameworkState.injectedModuleProvider);
        builder.addDependency(IntegrationServices.LOCK_MANAGER, LockManager.class, this.frameworkState.injectedLockManager);
        builder.addDependency(IntegrationServices.MODULE_MANGER, ModuleManager.class, this.frameworkState.injectedModuleManager);
        builder.addDependency(IntegrationServices.SYSTEM_PATHS, SystemPaths.class, this.frameworkState.injectedSystemPaths);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected SystemBundleState createServiceValue(StartContext startContext) throws StartException {
        StorageState storageState = null;
        BundleManagerPlugin bundleManager = this.frameworkState.getBundleManagerPlugin();
        try {
            OSGiMetaData metadata = this.createMetaData();
            storageState = this.createStorageState();
            SystemBundleRevision brev = new SystemBundleRevision(this.frameworkState, metadata, storageState);
            this.bundleState = new SystemBundleState(this.frameworkState, brev);
            this.bundleState.changeState(8);
            this.addToEnvironment(brev);
            this.bundleState.createBundleContext();
            bundleManager.injectedSystemBundle.inject((Object)this.bundleState);
        }
        catch (BundleException ex) {
            if (storageState != null) {
                BundleStorage storagePlugin = this.frameworkState.getBundleStorage();
                storagePlugin.deleteStorageState(storageState);
            }
            throw new StartException((Throwable)ex);
        }
        return this.bundleState;
    }

    public void stop(StopContext context) {
        BundleManagerPlugin bundleManager = this.frameworkState.getBundleManagerPlugin();
        bundleManager.injectedSystemBundle.uninject();
    }

    private StorageState createStorageState() {
        try {
            BundleStorage storagePlugin = this.frameworkState.getBundleStorage();
            return storagePlugin.createStorageState(0L, "System Bundle", 0, null);
        }
        catch (IOException ex) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotCreateSystemBundleStorage(ex);
        }
    }

    private OSGiMetaData createMetaData() {
        OSGiMetaDataBuilder builder = OSGiMetaDataBuilder.createBuilder((String)"system.bundle", (Version)Version.emptyVersion);
        SystemPaths systemPackages = this.frameworkState.getSystemPathsPlugin();
        ArrayList<String> exportedPackages = new ArrayList<String>();
        exportedPackages.addAll(systemPackages.getSystemPackages());
        for (String packageSpec : exportedPackages) {
            builder.addExportPackages(new String[]{packageSpec});
        }
        return builder.getOSGiMetaData();
    }

    private void addToEnvironment(SystemBundleRevision sysrev) {
        XEnvironment env = this.frameworkState.getEnvironment();
        env.installResources(new XResource[]{sysrev});
    }
}

