/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Stack;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.osgi.framework.Bundle;

final class LazyActivationTracker {
    private static final ThreadLocal<Stack<HostBundleState>> stackAssociation = new ThreadLocal();
    private static final ThreadLocal<HostBundleState> initiatorAssociation = new ThreadLocal();

    LazyActivationTracker() {
    }

    static void startTracking(HostBundleState hostBundle, String className) {
        FrameworkLogger.LOGGER.tracef("startTracking %s from: %s", className, hostBundle);
        initiatorAssociation.set(hostBundle);
    }

    static void processLoadedClass(Class<?> loadedClass) {
        assert (initiatorAssociation.get() != null) : "No activation initiator";
        FrameworkLogger.LOGGER.tracef("processLoadedClass: %s", loadedClass.getName());
        LazyActivationTracker.processActivationStack();
    }

    static void preDefineClass(HostBundleState hostBundle, String className) {
        FrameworkLogger.LOGGER.tracef("preDefineClass %s from: %s", className, hostBundle);
        LazyActivationTracker.addDefinedClass(hostBundle, className);
    }

    static void postDefineClass(HostBundleState hostBundle, Class<?> definedClass) {
        FrameworkLogger.LOGGER.tracef("postDefineClass %s from: %s", definedClass.getName(), hostBundle);
        if (initiatorAssociation.get() == null) {
            LazyActivationTracker.processActivationStack();
        }
    }

    static void stopTracking(HostBundleState hostBundle, String className) {
        FrameworkLogger.LOGGER.tracef("stopTracking %s from: %s", className, hostBundle);
        initiatorAssociation.remove();
        stackAssociation.remove();
    }

    private static void addDefinedClass(HostBundleState hostBundle, String className) {
        if (hostBundle.awaitLazyActivation() && !hostBundle.isAlreadyStarting()) {
            Stack<HostBundleState> stack = stackAssociation.get();
            if (stack == null) {
                stack = new Stack();
                stackAssociation.set(stack);
            }
            if (!stack.contains(hostBundle)) {
                FrameworkLogger.LOGGER.tracef("addDefinedClass %s from: %s", className, hostBundle);
                stack.push(hostBundle);
            }
        }
    }

    private static void processActivationStack() {
        Stack<HostBundleState> stack = stackAssociation.get();
        if (stack != null) {
            FrameworkLogger.LOGGER.tracef("processActivationStack: %s", stack);
            while (!stack.isEmpty()) {
                HostBundleState hostBundle = stack.pop();
                if (!hostBundle.awaitLazyActivation()) continue;
                try {
                    hostBundle.activateLazily();
                }
                catch (Throwable th) {
                    FrameworkLogger.LOGGER.errorCannotActivateBundleLazily(th, (Bundle)hostBundle);
                }
            }
        }
    }
}

