/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractFrameworkService;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class FrameworkInit
extends AbstractFrameworkService {
    private final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();
    private final ServiceController.Mode initialMode;

    FrameworkInit(ServiceController.Mode initialMode) {
        super(IntegrationServices.FRAMEWORK_INIT_INTERNAL);
        this.initialMode = initialMode;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkState> builder) {
        builder.addDependency(IntegrationServices.FRAMEWORK_CREATE_INTERNAL, FrameworkState.class, this.injectedFramework);
        builder.addDependencies(new ServiceName[]{IntegrationServices.FRAMEWORK_CORE_SERVICES});
        builder.addDependencies(new ServiceName[]{IntegrationServices.BOOTSTRAP_BUNDLES_INSTALL, IntegrationServices.BOOTSTRAP_BUNDLES_COMPLETE});
        builder.addDependencies(new ServiceName[]{IntegrationServices.PERSISTENT_BUNDLES_INSTALL, IntegrationServices.PERSISTENT_BUNDLES_COMPLETE});
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected FrameworkState createServiceValue(StartContext startContext) throws StartException {
        FrameworkLogger.LOGGER.debugf("OSGi Framework initialized", new Object[0]);
        return (FrameworkState)this.injectedFramework.getValue();
    }

    @Override
    public ServiceController<FrameworkState> install(ServiceTarget serviceTarget, ServiceListener<Object> listener) {
        ServiceController controller = super.install(serviceTarget, listener);
        new FrameworkInitialized().install(serviceTarget, listener);
        new SystemContextService().install(serviceTarget, listener);
        new SystemBundleService().install(serviceTarget, listener);
        return controller;
    }

    private class SystemBundleService
    extends AbstractIntegrationService<Bundle> {
        private final InjectedValue<BundleContext> injectedBundleContext;

        private SystemBundleService() {
            super(Services.SYSTEM_BUNDLE);
            this.injectedBundleContext = new InjectedValue();
        }

        @Override
        protected void addServiceDependencies(ServiceBuilder<Bundle> builder) {
            builder.addDependency(Services.FRAMEWORK_INIT, BundleContext.class, this.injectedBundleContext);
            builder.setInitialMode(FrameworkInit.this.initialMode);
        }

        @Override
        protected Bundle createServiceValue(StartContext startContext) throws StartException {
            return ((BundleContext)this.injectedBundleContext.getValue()).getBundle();
        }
    }

    private class SystemContextService
    extends AbstractIntegrationService<BundleContext> {
        private final InjectedValue<BundleContext> injectedBundleContext;

        private SystemContextService() {
            super(Services.SYSTEM_CONTEXT);
            this.injectedBundleContext = new InjectedValue();
        }

        @Override
        protected void addServiceDependencies(ServiceBuilder<BundleContext> builder) {
            builder.addDependency(Services.FRAMEWORK_INIT, BundleContext.class, this.injectedBundleContext);
            builder.setInitialMode(FrameworkInit.this.initialMode);
        }

        @Override
        protected BundleContext createServiceValue(StartContext startContext) throws StartException {
            return (BundleContext)this.injectedBundleContext.getValue();
        }
    }

    private class FrameworkInitialized
    extends AbstractIntegrationService<BundleContext> {
        private final InjectedValue<BundleContext> injectedBundleContext;

        private FrameworkInitialized() {
            super(Services.FRAMEWORK_INIT);
            this.injectedBundleContext = new InjectedValue();
        }

        @Override
        protected void addServiceDependencies(ServiceBuilder<BundleContext> builder) {
            builder.addDependency(IntegrationServices.SYSTEM_CONTEXT_INTERNAL, BundleContext.class, this.injectedBundleContext);
            builder.addDependency(IntegrationServices.FRAMEWORK_INIT_INTERNAL);
            builder.setInitialMode(FrameworkInit.this.initialMode);
        }

        @Override
        protected BundleContext createServiceValue(StartContext startContext) throws StartException {
            return (BundleContext)this.injectedBundleContext.getValue();
        }
    }
}

