/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractFrameworkService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StartLevelSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class FrameworkActive
extends AbstractFrameworkService {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();
    private final ServiceController.Mode initialMode;

    FrameworkActive(ServiceController.Mode initialMode) {
        super(IntegrationServices.FRAMEWORK_ACTIVE_INTERNAL);
        this.initialMode = initialMode;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkState> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, this.injectedBundleManager);
        builder.addDependency(IntegrationServices.FRAMEWORK_INIT_INTERNAL, FrameworkState.class, this.injectedFramework);
        builder.addDependency(Services.FRAMEWORK_INIT);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected FrameworkState createServiceValue(StartContext startContext) throws StartException {
        FrameworkState frameworkState = (FrameworkState)this.injectedFramework.getValue();
        BundleManagerPlugin bundleManager = frameworkState.getBundleManagerPlugin();
        SystemBundleState systemBundle = frameworkState.getSystemBundle();
        systemBundle.changeState(32);
        StartLevelSupport startLevelPlugin = frameworkState.getCoreServices().getStartLevelSupport();
        startLevelPlugin.increaseStartLevel(this.getBeginningStartLevel(bundleManager));
        bundleManager.injectedFrameworkActive.inject((Object)Boolean.TRUE);
        FrameworkEvents eventsPlugin = frameworkState.getFrameworkEvents();
        eventsPlugin.fireFrameworkEvent((Bundle)systemBundle, 1, null);
        FrameworkLogger.LOGGER.infoFrameworkStarted();
        return frameworkState;
    }

    @Override
    public ServiceController<FrameworkState> install(ServiceTarget serviceTarget, ServiceListener<Object> listener) {
        ServiceController controller = super.install(serviceTarget, listener);
        new FrameworkActivated().install(serviceTarget, listener);
        return controller;
    }

    public void stop(StopContext context) {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        bundleManager.injectedFrameworkActive.uninject();
        super.stop(context);
    }

    private int getBeginningStartLevel(BundleManagerPlugin bundleManager) {
        String levelSpec = (String)bundleManager.getProperty("org.osgi.framework.startlevel.beginning");
        if (levelSpec != null) {
            try {
                return Integer.parseInt(levelSpec);
            }
            catch (NumberFormatException nfe) {
                FrameworkLogger.LOGGER.errorInvalidBeginningStartLevel(levelSpec);
            }
        }
        return 1;
    }

    private class FrameworkActivated
    extends AbstractIntegrationService<BundleContext> {
        private final InjectedValue<BundleContext> injectedBundleContext;

        private FrameworkActivated() {
            super(Services.FRAMEWORK_ACTIVE);
            this.injectedBundleContext = new InjectedValue();
        }

        @Override
        protected void addServiceDependencies(ServiceBuilder<BundleContext> builder) {
            builder.addDependency(IntegrationServices.SYSTEM_CONTEXT_INTERNAL, BundleContext.class, this.injectedBundleContext);
            builder.addDependency(IntegrationServices.FRAMEWORK_ACTIVE_INTERNAL);
            builder.setInitialMode(FrameworkActive.this.initialMode);
        }

        @Override
        protected BundleContext createServiceValue(StartContext startContext) throws StartException {
            return (BundleContext)this.injectedBundleContext.getValue();
        }
    }
}

