/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.dom.ExtendedDocumentBuilder;
import org.apache.cxf.tools.common.toolspec.Tool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolSpec {
    private static final Logger LOG = LogUtils.getL7dLogger(ToolSpec.class);
    private final ExtendedDocumentBuilder builder = new ExtendedDocumentBuilder();
    private Document doc;
    private Tool handler;

    public ToolSpec() {
    }

    public ToolSpec(InputStream in) throws ToolException {
        this(in, true);
    }

    public ToolSpec(InputStream in, boolean validate) throws ToolException {
        if (in == null) {
            throw new NullPointerException("Cannot create a ToolSpec object from a null stream");
        }
        try {
            this.builder.setValidating(validate);
            this.doc = this.builder.parse(in);
        }
        catch (Exception ex) {
            Message message = new Message("FAIL_TO_PARSING_TOOLSPCE_STREAM", LOG, new Object[0]);
            throw new ToolException(message, (Throwable)ex);
        }
    }

    public ToolSpec(Document d) {
        if (d == null) {
            throw new NullPointerException("Cannot create a ToolSpec object from a null org.w3c.dom.Document");
        }
        this.doc = d;
    }

    public ExtendedDocumentBuilder getDocumentBuilder() {
        return this.builder;
    }

    public boolean isValidInputStream(String id) {
        Element streams = this.getStreams();
        if (streams == null) {
            return false;
        }
        List elemList = DOMUtils.findAllElementsByTagNameNS((Element)streams, (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"instream");
        for (Element elem : elemList) {
            if (!elem.getAttribute("id").equals(id)) continue;
            return true;
        }
        return false;
    }

    public Element getElementById(String id) {
        Element ele = this.doc.getElementById(id);
        if (ele != null) {
            return ele;
        }
        XPathUtils xpather = new XPathUtils(new HashMap());
        NodeList nl = (NodeList)xpather.getValue("//*[@id='" + id + "']", (Node)this.doc, XPathConstants.NODESET);
        if (nl != null && nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    public boolean hasHandler() {
        return this.doc.getDocumentElement().hasAttribute("handler");
    }

    public Tool getHandler() throws ToolException {
        if (!this.hasHandler()) {
            return null;
        }
        if (this.handler == null) {
            String handlerClz = this.doc.getDocumentElement().getAttribute("handler");
            try {
                this.handler = (Tool)Class.forName(handlerClz).newInstance();
            }
            catch (Exception ex) {
                Message message = new Message("FAIL_TO_INSTANTIATE_HANDLER", LOG, new Object[]{handlerClz});
                throw new ToolException(message, (Throwable)ex);
            }
        }
        return this.handler;
    }

    public Tool getHandler(ClassLoader loader) throws ToolException {
        if (!this.hasHandler()) {
            return null;
        }
        if (this.handler == null) {
            String handlerClz = this.doc.getDocumentElement().getAttribute("handler");
            try {
                this.handler = (Tool)Class.forName(handlerClz, true, loader).newInstance();
            }
            catch (Exception ex) {
                Message message = new Message("FAIL_TO_INSTANTIATE_HANDLER", LOG, new Object[]{handlerClz});
                throw new ToolException(message, (Throwable)ex);
            }
        }
        return this.handler;
    }

    public Element getStreams() {
        List elemList = DOMUtils.findAllElementsByTagNameNS((Element)this.doc.getDocumentElement(), (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"streams");
        if (elemList.size() > 0) {
            return (Element)elemList.get(0);
        }
        return null;
    }

    public List<String> getInstreamIds() {
        ArrayList<String> res = new ArrayList<String>();
        Element streams = this.getStreams();
        if (streams != null) {
            List elemList = DOMUtils.findAllElementsByTagNameNS((Element)streams, (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"instream");
            for (Element elem : elemList) {
                res.add(elem.getAttribute("id"));
            }
        }
        return Collections.unmodifiableList(res);
    }

    public List<String> getOutstreamIds() {
        ArrayList<String> res = new ArrayList<String>();
        Element streams = this.getStreams();
        if (streams != null) {
            List elemList = DOMUtils.findAllElementsByTagNameNS((Element)streams, (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"outstream");
            for (Element elem : elemList) {
                res.add(elem.getAttribute("id"));
            }
        }
        return Collections.unmodifiableList(res);
    }

    public Element getUsage() {
        return (Element)DOMUtils.findAllElementsByTagNameNS((Element)this.doc.getDocumentElement(), (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"usage").get(0);
    }

    public void transform(InputStream stylesheet, OutputStream out) throws TransformerException {
        Transformer trans = TransformerFactory.newInstance().newTransformer(new StreamSource(stylesheet));
        trans.transform(new DOMSource(this.doc), new StreamResult(out));
    }

    public Element getPipeline() {
        List elemList = DOMUtils.findAllElementsByTagNameNS((Element)this.doc.getDocumentElement(), (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"pipeline");
        if (elemList.size() > 0) {
            return (Element)elemList.get(0);
        }
        return null;
    }

    public List<Element> getUsageForms() {
        return DOMUtils.findAllElementsByTagNameNS((Element)this.getUsage(), (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"form");
    }

    public String getStreamRefName(String streamId) {
        if (this.getUsage() != null) {
            List elemList = DOMUtils.findAllElementsByTagNameNS((Element)this.getUsage(), (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"associatedArgument");
            for (Element elem : elemList) {
                if (!elem.getAttribute("streamref").equals(streamId)) continue;
                return ((Element)elem.getParentNode()).getAttribute("id");
            }
            elemList = DOMUtils.findAllElementsByTagNameNS((Element)this.getUsage(), (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"argument");
            for (Element elem : elemList) {
                if (!elem.getAttribute("streamref").equals(streamId)) continue;
                return elem.getAttribute("id");
            }
        }
        return null;
    }

    public String getParameterDefault(String name) {
        Element el = this.getElementById(name);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Element with id " + name + " is " + el);
        }
        if (el != null) {
            Element assArg;
            List elemList;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("local name is " + el.getLocalName());
            }
            if ("argument".equals(el.getLocalName())) {
                if (el.hasAttribute("default")) {
                    return el.getAttribute("default");
                }
            } else if ("option".equals(el.getLocalName()) && (elemList = DOMUtils.findAllElementsByTagNameNS((Element)el, (String)"http://cxf.apache.org/Xpipe/ToolSpecification", (String)"associatedArgument")).size() > 0 && (assArg = (Element)elemList.get(0)).hasAttribute("default")) {
                return assArg.getAttribute("default");
            }
        }
        return null;
    }

    public String getAnnotation() {
        String result = null;
        Element element = this.doc.getDocumentElement();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !"annotation".equals(node.getNodeName())) continue;
            result = node.getNodeValue();
            break;
        }
        return result;
    }
}

