/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.http.AbstractHttpWebServiceMessageSender;
import org.springframework.ws.transport.http.HttpComponentsConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpComponentsMessageSender
extends AbstractHttpWebServiceMessageSender
implements InitializingBean,
DisposableBean {
    private static final int DEFAULT_CONNECTION_TIMEOUT_MILLISECONDS = 60000;
    private static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    private HttpClient httpClient;
    private Credentials credentials;
    private AuthScope authScope = AuthScope.ANY;

    public HttpComponentsMessageSender() {
        DefaultHttpClient defaultClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager());
        defaultClient.addRequestInterceptor((HttpRequestInterceptor)new RemoveSoapHeadersInterceptor(), 0);
        this.httpClient = defaultClient;
        this.setConnectionTimeout(60000);
        this.setReadTimeout(60000);
    }

    public HttpComponentsMessageSender(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"httpClient must not be null");
        this.httpClient = httpClient;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setConnectionTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must be a non-negative value");
        }
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.getHttpClient().getParams(), (int)timeout);
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must be a non-negative value");
        }
        HttpConnectionParams.setSoTimeout((HttpParams)this.getHttpClient().getParams(), (int)timeout);
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        if (maxTotalConnections <= 0) {
            throw new IllegalArgumentException("maxTotalConnections must be a positive value");
        }
        ClientConnectionManager connectionManager = this.getHttpClient().getConnectionManager();
        if (!(connectionManager instanceof ThreadSafeClientConnManager)) {
            throw new IllegalArgumentException("maxTotalConnections is not supported on " + connectionManager.getClass().getName() + ". Use " + ThreadSafeClientConnManager.class.getName() + " instead");
        }
        ((ThreadSafeClientConnManager)connectionManager).setMaxTotal(maxTotalConnections);
    }

    public void setMaxConnectionsPerHost(Map<String, String> maxConnectionsPerHost) throws URISyntaxException {
        ClientConnectionManager connectionManager = this.getHttpClient().getConnectionManager();
        if (!(connectionManager instanceof ThreadSafeClientConnManager)) {
            throw new IllegalArgumentException("maxConnectionsPerHost is not supported on " + connectionManager.getClass().getName() + ". Use " + ThreadSafeClientConnManager.class.getName() + " instead");
        }
        Iterator<String> i$ = maxConnectionsPerHost.keySet().iterator();
        while (i$.hasNext()) {
            String o;
            String host = o = i$.next();
            URI uri = new URI(host);
            HttpHost httpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            int maxHostConnections = Integer.parseInt(maxConnectionsPerHost.get(host));
            ((ThreadSafeClientConnManager)connectionManager).setMaxForRoute(new HttpRoute(httpHost), maxHostConnections);
        }
    }

    public void setAuthScope(AuthScope authScope) {
        this.authScope = authScope;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.credentials != null && this.getHttpClient() instanceof DefaultHttpClient) {
            ((DefaultHttpClient)this.getHttpClient()).getCredentialsProvider().setCredentials(this.authScope, this.credentials);
        }
    }

    @Override
    public WebServiceConnection createConnection(URI uri) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.isAcceptGzipEncoding()) {
            httpPost.addHeader("Accept-Encoding", "gzip");
        }
        HttpContext httpContext = this.createContext(uri);
        return new HttpComponentsConnection(this.getHttpClient(), httpPost, httpContext);
    }

    protected HttpContext createContext(URI uri) {
        return null;
    }

    public void destroy() throws Exception {
        this.getHttpClient().getConnectionManager().shutdown();
    }

    private static class RemoveSoapHeadersInterceptor
    implements HttpRequestInterceptor {
        private RemoveSoapHeadersInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (request instanceof HttpEntityEnclosingRequest) {
                if (request.containsHeader("Transfer-Encoding")) {
                    request.removeHeaders("Transfer-Encoding");
                }
                if (request.containsHeader("Content-Length")) {
                    request.removeHeaders("Content-Length");
                }
            }
        }
    }
}

