/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint;

import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.xml.transform.TransformerObjectSupport;

public abstract class AbstractLoggingInterceptor
extends TransformerObjectSupport
implements EndpointInterceptor {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private boolean logRequest = true;
    private boolean logResponse = true;

    public final void setLogRequest(boolean logRequest) {
        this.logRequest = logRequest;
    }

    public final void setLogResponse(boolean logResponse) {
        this.logResponse = logResponse;
    }

    public void setLoggerName(String loggerName) {
        this.logger = LogFactory.getLog((String)loggerName);
    }

    public final boolean handleRequest(MessageContext messageContext, Object endpoint) throws TransformerException {
        if (this.logRequest && this.isLogEnabled()) {
            this.logMessageSource("Request: ", this.getSource(messageContext.getRequest()));
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        if (this.logResponse && this.isLogEnabled()) {
            this.logMessageSource("Response: ", this.getSource(messageContext.getResponse()));
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        return true;
    }

    public void afterCompletion(MessageContext messageContext, Object endpoint, Exception ex) {
    }

    protected boolean isLogEnabled() {
        return this.logger.isDebugEnabled();
    }

    private Transformer createNonIndentingTransformer() throws TransformerConfigurationException {
        Transformer transformer = this.createTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "no");
        return transformer;
    }

    protected void logMessageSource(String logMessage, Source source) throws TransformerException {
        if (source != null) {
            Transformer transformer = this.createNonIndentingTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(source, new StreamResult(writer));
            String message = logMessage + writer.toString();
            this.logMessage(message);
        }
    }

    protected void logMessage(String message) {
        this.logger.debug((Object)message);
    }

    protected abstract Source getSource(WebServiceMessage var1);
}

