/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.ext;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.ComponentDefinitionRegistryProcessor;
import org.apache.aries.blueprint.mutable.MutableBeanArgument;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanProperty;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutableMapEntry;
import org.apache.aries.blueprint.mutable.MutableMapMetadata;
import org.apache.aries.blueprint.mutable.MutablePropsMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceListener;
import org.apache.aries.blueprint.mutable.MutableRegistrationListener;
import org.apache.aries.blueprint.mutable.MutableServiceMetadata;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.PropsMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListener;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.RegistrationListener;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyPlaceholder
implements ComponentDefinitionRegistryProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPropertyPlaceholder.class);
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private Pattern pattern;

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    @Override
    public void process(ComponentDefinitionRegistry registry) throws ComponentDefinitionException {
        for (String name : registry.getComponentDefinitionNames()) {
            this.processMetadata(registry.getComponentDefinition(name));
        }
    }

    protected Metadata processMetadata(Metadata metadata) {
        if (metadata instanceof BeanMetadata) {
            return this.processBeanMetadata((BeanMetadata)metadata);
        }
        if (metadata instanceof ReferenceListMetadata) {
            return this.processRefCollectionMetadata((ReferenceListMetadata)metadata);
        }
        if (metadata instanceof ReferenceMetadata) {
            return this.processReferenceMetadata((ReferenceMetadata)metadata);
        }
        if (metadata instanceof ServiceMetadata) {
            return this.processServiceMetadata((ServiceMetadata)metadata);
        }
        if (metadata instanceof CollectionMetadata) {
            return this.processCollectionMetadata((CollectionMetadata)metadata);
        }
        if (metadata instanceof MapMetadata) {
            return this.processMapMetadata((MapMetadata)metadata);
        }
        if (metadata instanceof PropsMetadata) {
            return this.processPropsMetadata((PropsMetadata)metadata);
        }
        if (metadata instanceof ValueMetadata) {
            return this.processValueMetadata((ValueMetadata)metadata);
        }
        return metadata;
    }

    protected Metadata processBeanMetadata(BeanMetadata component) {
        for (BeanArgument arg : component.getArguments()) {
            ((MutableBeanArgument)arg).setValue(this.processMetadata(arg.getValue()));
        }
        for (BeanProperty prop : component.getProperties()) {
            ((MutableBeanProperty)prop).setValue(this.processMetadata(prop.getValue()));
        }
        ((MutableBeanMetadata)component).setFactoryComponent((Target)this.processMetadata(component.getFactoryComponent()));
        return component;
    }

    protected Metadata processServiceMetadata(ServiceMetadata component) {
        ((MutableServiceMetadata)component).setServiceComponent((Target)this.processMetadata(component.getServiceComponent()));
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>(component.getServiceProperties());
        for (MapEntry entry : entries) {
            ((MutableServiceMetadata)component).removeServiceProperty(entry);
        }
        for (MapEntry entry : this.processMapEntries(entries)) {
            ((MutableServiceMetadata)component).addServiceProperty(entry);
        }
        for (RegistrationListener listener : component.getRegistrationListeners()) {
            ((MutableRegistrationListener)listener).setListenerComponent((Target)this.processMetadata(listener.getListenerComponent()));
        }
        return component;
    }

    protected Metadata processReferenceMetadata(ReferenceMetadata component) {
        for (ReferenceListener listener : component.getReferenceListeners()) {
            ((MutableReferenceListener)listener).setListenerComponent((Target)this.processMetadata(listener.getListenerComponent()));
        }
        return component;
    }

    protected Metadata processRefCollectionMetadata(ReferenceListMetadata component) {
        for (ReferenceListener listener : component.getReferenceListeners()) {
            ((MutableReferenceListener)listener).setListenerComponent((Target)this.processMetadata(listener.getListenerComponent()));
        }
        return component;
    }

    protected Metadata processPropsMetadata(PropsMetadata metadata) {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>(metadata.getEntries());
        for (MapEntry entry : entries) {
            ((MutablePropsMetadata)metadata).removeEntry(entry);
        }
        for (MapEntry entry : this.processMapEntries(entries)) {
            ((MutablePropsMetadata)metadata).addEntry(entry);
        }
        return metadata;
    }

    protected Metadata processMapMetadata(MapMetadata metadata) {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>(metadata.getEntries());
        for (MapEntry entry : entries) {
            ((MutableMapMetadata)metadata).removeEntry(entry);
        }
        for (MapEntry entry : this.processMapEntries(entries)) {
            ((MutableMapMetadata)metadata).addEntry(entry);
        }
        return metadata;
    }

    protected List<MapEntry> processMapEntries(List<MapEntry> entries) {
        for (MapEntry entry : entries) {
            ((MutableMapEntry)entry).setKey((NonNullMetadata)this.processMetadata(entry.getKey()));
            ((MutableMapEntry)entry).setValue(this.processMetadata(entry.getValue()));
        }
        return entries;
    }

    protected Metadata processCollectionMetadata(CollectionMetadata metadata) {
        ArrayList<Metadata> values = new ArrayList<Metadata>(metadata.getValues());
        for (Metadata value : values) {
            ((MutableCollectionMetadata)metadata).removeValue(value);
        }
        for (Metadata value : values) {
            ((MutableCollectionMetadata)metadata).addValue(this.processMetadata(value));
        }
        return metadata;
    }

    protected Metadata processValueMetadata(ValueMetadata metadata) {
        return new LateBindingValueMetadata(metadata);
    }

    protected String retrieveValue(String expression) {
        return this.getProperty(expression);
    }

    protected String processString(String str) {
        Matcher matcher = this.getPattern().matcher(str);
        while (matcher.find()) {
            String rep = this.retrieveValue(matcher.group(1));
            if (rep == null) continue;
            str = str.replace(matcher.group(0), rep);
            matcher.reset(str);
        }
        return str;
    }

    protected String getProperty(String val) {
        return null;
    }

    protected Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile("\\Q" + this.placeholderPrefix + "\\E(.+?)\\Q" + this.placeholderSuffix + "\\E");
        }
        return this.pattern;
    }

    public class LateBindingValueMetadata
    implements ValueMetadata {
        private final ValueMetadata metadata;
        private boolean retrieved;
        private String retrievedValue;

        public LateBindingValueMetadata(ValueMetadata metadata) {
            this.metadata = metadata;
        }

        public String getStringValue() {
            if (!this.retrieved) {
                String v = this.metadata.getStringValue();
                LOGGER.debug("Before process: {}", (Object)v);
                this.retrievedValue = AbstractPropertyPlaceholder.this.processString(v);
                LOGGER.debug("After process: {}", (Object)this.retrievedValue);
                this.retrieved = true;
            }
            return this.retrievedValue;
        }

        public String getType() {
            return this.metadata.getType();
        }
    }
}

