/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.concurrent.Callable;
import org.apache.aries.blueprint.ExtendedReferenceListMetadata;
import org.apache.aries.blueprint.container.AbstractServiceReferenceRecipe;
import org.apache.aries.blueprint.container.AggregateConverter;
import org.apache.aries.blueprint.di.CollectionRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.utils.DynamicCollection;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.ReifiedType;
import org.osgi.service.blueprint.container.ServiceUnavailableException;
import org.osgi.service.blueprint.reflect.ReferenceListMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceListRecipe
extends AbstractServiceReferenceRecipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceListRecipe.class);
    private final ReferenceListMetadata metadata;
    private final List<ManagedCollection> collections = new ArrayList<ManagedCollection>();
    private final DynamicCollection<ServiceDispatcher> storage = new DynamicCollection();
    private final List<ServiceDispatcher> unboundDispatchers = new ArrayList<ServiceDispatcher>();
    private final Object monitor = new Object();

    public ReferenceListRecipe(String name, ExtendedBlueprintContainer blueprintContainer, ReferenceListMetadata metadata, CollectionRecipe listenersRecipe, List<Recipe> explicitDependencies) {
        super(name, blueprintContainer, metadata, listenersRecipe, explicitDependencies);
        this.metadata = metadata;
    }

    @Override
    protected Object internalCreate() throws ComponentDefinitionException {
        try {
            if (this.explicitDependencies != null) {
                for (Recipe recipe : this.explicitDependencies) {
                    recipe.create();
                }
            }
            ProvidedObject object = new ProvidedObject();
            this.addPartialObject(object);
            this.createListeners();
            this.updateListeners();
            return object;
        }
        catch (ComponentDefinitionException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new ComponentDefinitionException(t);
        }
    }

    @Override
    protected void retrack() {
        List<ServiceReference> refs = this.getServiceReferences();
        if (refs != null) {
            for (ServiceReference ref : refs) {
                this.track(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void track(ServiceReference reference) {
        Object object = this.monitor;
        synchronized (object) {
            try {
                ServiceDispatcher dispatcher = this.findDispatcher(reference);
                if (dispatcher != null) {
                    if (!this.unboundDispatchers.remove(dispatcher)) {
                        return;
                    }
                } else {
                    dispatcher = new ServiceDispatcher(reference);
                    HashSet interfaces = new HashSet();
                    Class clz = this.getInterfaceClass();
                    if (clz != null) {
                        interfaces.add(clz);
                    }
                    if (this.metadata instanceof ExtendedReferenceListMetadata) {
                        boolean greedy;
                        boolean bl = greedy = (((ExtendedReferenceListMetadata)this.metadata).getProxyMethod() & 2) != 0;
                        if (greedy) {
                            List<String> ifs = Arrays.asList((String[])reference.getProperty("objectClass"));
                            interfaces.addAll(this.loadAllClasses(ifs));
                        }
                    }
                    dispatcher.proxy = this.createProxy(dispatcher, interfaces);
                    if (!this.storage.add(dispatcher)) {
                        dispatcher.destroy();
                        return;
                    }
                }
                if (this.listeners != null) {
                    this.bind(dispatcher.reference, dispatcher.proxy);
                } else {
                    this.unboundDispatchers.add(dispatcher);
                }
            }
            catch (Throwable t) {
                LOGGER.info("Error tracking new service reference", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void untrack(ServiceReference reference) {
        Object object = this.monitor;
        synchronized (object) {
            ServiceDispatcher dispatcher = this.findDispatcher(reference);
            if (dispatcher != null) {
                this.unbind(dispatcher.reference, dispatcher.proxy);
                this.storage.remove(dispatcher);
                dispatcher.destroy();
            }
        }
    }

    protected ServiceDispatcher findDispatcher(ServiceReference reference) {
        for (ServiceDispatcher dispatcher : this.storage) {
            if (dispatcher.reference != reference) continue;
            return dispatcher;
        }
        return null;
    }

    protected ManagedCollection getManagedCollection(boolean useReferences) {
        for (ManagedCollection col : this.collections) {
            if (col.references != useReferences) continue;
            return col;
        }
        ManagedCollection collection = new ManagedCollection(useReferences, this.storage);
        this.collections.add(collection);
        return collection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ManagedCollection
    extends AbstractCollection
    implements List,
    RandomAccess {
        protected final DynamicCollection<ServiceDispatcher> dispatchers;
        protected boolean references;

        public ManagedCollection(boolean references, DynamicCollection<ServiceDispatcher> dispatchers) {
            this.references = references;
            this.dispatchers = dispatchers;
            LOGGER.debug("ManagedCollection references={}", (Object)references);
        }

        public boolean addDispatcher(ServiceDispatcher dispatcher) {
            return this.dispatchers.add(dispatcher);
        }

        public boolean removeDispatcher(ServiceDispatcher dispatcher) {
            return this.dispatchers.remove(dispatcher);
        }

        public DynamicCollection<ServiceDispatcher> getDispatchers() {
            return this.dispatchers;
        }

        @Override
        public Iterator iterator() {
            return new ManagedListIterator(this.dispatchers.iterator());
        }

        @Override
        public int size() {
            return this.dispatchers.size();
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException("This collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("This collection is read only");
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("This collection is read only");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("This collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("This collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("This collection is read only");
        }

        public Object get(int index) {
            return this.references ? this.dispatchers.get((int)index).reference : this.dispatchers.get((int)index).proxy;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            ListIterator e = this.listIterator();
            while (e.hasNext()) {
                if (!o.equals(e.next())) continue;
                return e.previousIndex();
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            ListIterator e = this.listIterator(this.size());
            while (e.hasPrevious()) {
                if (!o.equals(e.previous())) continue;
                return e.nextIndex();
            }
            return -1;
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int index) {
            return new ManagedListIterator(this.dispatchers.iterator(index));
        }

        public List<ServiceDispatcher> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException("This collection is read only");
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException("This collection is read only");
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException("This collection is read only");
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException("This collection is read only");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ManagedListIterator
        implements ListIterator {
            protected final ListIterator<ServiceDispatcher> iterator;

            public ManagedListIterator(ListIterator<ServiceDispatcher> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Object next() {
                return ManagedCollection.this.references ? this.iterator.next().reference : this.iterator.next().proxy;
            }

            @Override
            public boolean hasPrevious() {
                return this.iterator.hasPrevious();
            }

            public Object previous() {
                return ManagedCollection.this.references ? this.iterator.previous().reference : this.iterator.previous().proxy;
            }

            @Override
            public int nextIndex() {
                return this.iterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.iterator.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This collection is read only");
            }

            public void set(Object o) {
                throw new UnsupportedOperationException("This collection is read only");
            }

            public void add(Object o) {
                throw new UnsupportedOperationException("This collection is read only");
            }
        }
    }

    public class ProvidedObject
    implements AggregateConverter.Convertible {
        public Object convert(ReifiedType type) {
            LOGGER.debug("Converting ManagedCollection to {}", (Object)type);
            if (!type.getRawClass().isAssignableFrom(List.class)) {
                throw new ComponentDefinitionException("<reference-list/> can only be converted to a List, not " + type);
            }
            int memberType = ReferenceListRecipe.this.metadata.getMemberType();
            boolean useRef = false;
            if (type.size() == 1) {
                boolean bl = useRef = type.getActualTypeArgument(0).getRawClass() == ServiceReference.class;
                if (useRef && memberType == 1 || !useRef && memberType == 2) {
                    throw new ComponentDefinitionException("The memeber-type specified is incompatible with generic injection type");
                }
            }
            boolean references = memberType == 2 ? true : (memberType == 1 ? false : useRef);
            LOGGER.debug("ManagedCollection references={}", (Object)references);
            return ReferenceListRecipe.this.getManagedCollection(references);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ServiceDispatcher
    implements Callable<Object> {
        public ServiceReference reference;
        public Object service;
        public Object proxy;

        public ServiceDispatcher(ServiceReference reference) throws Exception {
            this.reference = reference;
        }

        public synchronized void destroy() {
            if (this.reference != null) {
                this.reference.getBundle().getBundleContext().ungetService(this.reference);
                this.reference = null;
                this.service = null;
                this.proxy = null;
            }
        }

        @Override
        public synchronized Object call() throws Exception {
            if (this.reference == null) {
                throw new ServiceUnavailableException("Service is unavailable", ReferenceListRecipe.this.getOsgiFilter());
            }
            if (this.service == null) {
                this.service = ReferenceListRecipe.this.getBundleContextForServiceLookup().getService(this.reference);
            }
            return this.service;
        }
    }
}

