/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import javax.wsdl.Definition;
import org.jboss.ws.NativeLoggers;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.common.IOUtils;
import org.jboss.ws.common.utils.AbstractWSDLFilePublisher;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.tools.wsdl.WSDLWriter;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.w3c.dom.Document;

public class WSDLFilePublisher
extends AbstractWSDLFilePublisher {
    public WSDLFilePublisher(ArchiveDeployment dep) {
        super(dep);
    }

    public void publishWsdlFiles(UnifiedMetaData wsMetaData) throws IOException {
        String deploymentName = this.dep.getCanonicalName();
        for (ServiceMetaData serviceMD : wsMetaData.getServices()) {
            String publishLocation;
            String wsdlLocation = this.getWSDLLocation(serviceMD);
            File wsdlFile = this.getPublishLocation(deploymentName, wsdlLocation, publishLocation = serviceMD.getWsdlPublishLocation());
            if (wsdlFile == null) continue;
            wsdlFile.getParentFile().mkdirs();
            Writer fWriter = null;
            try {
                fWriter = IOUtils.getCharsetFileWriter((File)wsdlFile, (String)"UTF-8");
                WSDLDefinitions wsdlDefinitions = serviceMD.getWsdlDefinitions();
                new WSDLWriter(wsdlDefinitions).write(fWriter, "UTF-8");
                URL wsdlPublishURL = wsdlFile.toURI().toURL();
                NativeLoggers.ROOT_LOGGER.wsdlFilePublished(wsdlPublishURL);
                serviceMD.setWsdlLocation(wsdlPublishURL);
                Definition wsdl11Definition = wsdlDefinitions.getWsdlOneOneDefinition();
                if (wsdl11Definition != null) {
                    LinkedList published = new LinkedList();
                    this.publishWsdlImports(wsdlPublishURL, wsdl11Definition, published);
                    Document document = wsdlDefinitions.getWsdlDocument();
                    this.publishSchemaImports(wsdlPublishURL, document.getDocumentElement(), published);
                    continue;
                }
                throw NativeMessages.MESSAGES.wsdl20NotSupported();
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw NativeMessages.MESSAGES.cannotPublishWSDLTo(wsdlFile, e);
            }
            finally {
                if (fWriter == null) continue;
                fWriter.close();
            }
        }
    }

    private String getWSDLLocation(ServiceMetaData serviceMD) {
        if (serviceMD.getWsdlFileOrLocation() == null) {
            return null;
        }
        return serviceMD.getWsdlFileOrLocation().toExternalForm();
    }

    private File getPublishLocation(String archiveName, String wsdlLocation, String wsdlPublishLocation) throws IOException {
        File result;
        if (wsdlLocation == null) {
            NativeLoggers.ROOT_LOGGER.cannotGetWsdlPublishLocation();
            return null;
        }
        String publishLocation = wsdlPublishLocation;
        boolean predefinedLocation = publishLocation != null && publishLocation.startsWith("file:");
        File locationFile = null;
        if (!predefinedLocation) {
            if (archiveName.startsWith("http://")) {
                archiveName = archiveName.replace("http://", "http-");
            }
            locationFile = new File(this.serverConfig.getServerDataDir().getCanonicalPath() + "/wsdl/" + archiveName);
        } else {
            try {
                locationFile = new File(new URL(publishLocation).getPath());
            }
            catch (MalformedURLException e) {
                throw NativeMessages.MESSAGES.invalidPublishLocation(publishLocation, e);
            }
        }
        if (wsdlLocation.indexOf(this.expLocation) >= 0) {
            wsdlLocation = wsdlLocation.substring(wsdlLocation.indexOf(this.expLocation) + this.expLocation.length());
            result = new File(locationFile + "/" + wsdlLocation);
        } else if (wsdlLocation.startsWith("vfs:") || wsdlLocation.startsWith("vfsfile:") || wsdlLocation.startsWith("file:") || wsdlLocation.startsWith("jar:") || wsdlLocation.startsWith("vfszip:")) {
            wsdlLocation = wsdlLocation.substring(wsdlLocation.lastIndexOf("/") + 1);
            result = new File(locationFile + "/" + wsdlLocation);
        } else {
            throw NativeMessages.MESSAGES.invalidWsdlFile(wsdlLocation, this.expLocation);
        }
        return result;
    }
}

