/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxrpc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.common.Constants;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.EncodedTypeMapping;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.core.jaxrpc.TypeMappingRegistryImpl;
import org.jboss.ws.core.soap.utils.Style;
import org.jboss.ws.core.soap.utils.Use;
import org.jboss.ws.metadata.builder.MetaDataBuilder;
import org.jboss.ws.metadata.jaxrpcmapping.ExceptionMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.ws.metadata.jaxrpcmapping.WsdlMessageMapping;
import org.jboss.ws.metadata.jaxrpcmapping.WsdlReturnValueMapping;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
import org.jboss.ws.metadata.umdm.TypesMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLMIMEPart;
import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;
import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.WSDLUtils;

public abstract class JAXRPCMetaDataBuilder
extends MetaDataBuilder {
    final Logger log = Logger.getLogger(JAXRPCMetaDataBuilder.class);

    protected QName lookupSchemaType(WSDLInterfaceOperation operation, QName element) {
        WSDLDefinitions wsdlDefinitions = operation.getWsdlInterface().getWsdlDefinitions();
        WSDLTypes wsdlTypes = wsdlDefinitions.getWsdlTypes();
        return wsdlTypes.getXMLType(element);
    }

    protected void setupTypesMetaData(ServiceMetaData serviceMetaData) {
        WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
        JavaWsdlMapping javaWsdlMapping = serviceMetaData.getJavaWsdlMapping();
        TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
        if (wsdlDefinitions != null) {
            WSDLTypes wsdlTypes = wsdlDefinitions.getWsdlTypes();
            typesMetaData.setSchemaModel(WSDLUtils.getSchemaModel(wsdlTypes));
        }
        if (javaWsdlMapping != null) {
            for (JavaXmlTypeMapping javaXmlTypeMapping : javaWsdlMapping.getJavaXmlTypeMappings()) {
                String nsURI;
                String javaTypeName = javaXmlTypeMapping.getJavaType();
                String qnameScope = javaXmlTypeMapping.getQnameScope();
                QName xmlType = javaXmlTypeMapping.getRootTypeQName();
                QName anonymousXMLType = javaXmlTypeMapping.getAnonymousTypeQName();
                if (xmlType == null && anonymousXMLType != null) {
                    xmlType = anonymousXMLType;
                }
                if ("http://www.w3.org/2001/XMLSchema".equals(nsURI = xmlType.getNamespaceURI()) || "http://schemas.xmlsoap.org/soap/encoding/".equals(nsURI)) continue;
                TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
                tmMetaData.setQNameScope(qnameScope);
                typesMetaData.addTypeMapping(tmMetaData);
            }
            for (Serializable serializable : javaWsdlMapping.getExceptionMappings()) {
                QName xmlType = ((ExceptionMapping)serializable).getWsdlMessage();
                String javaTypeName = ((ExceptionMapping)serializable).getExceptionType();
                TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
                typesMetaData.addTypeMapping(tmMetaData);
            }
        }
    }

    protected void setupOperationsFromWSDL(EndpointMetaData epMetaData, WSDLEndpoint wsdlEndpoint, ServiceEndpointInterfaceMapping seiMapping) {
        WSDLInterface wsdlInterface = wsdlEndpoint.getInterface();
        for (WSDLInterfaceOperation wsdlOperation : wsdlInterface.getOperations()) {
            String namespaceURI;
            QName opQName = wsdlOperation.getName();
            String opName = opQName.getLocalPart();
            WSDLBindingOperation wsdlBindingOperation = wsdlOperation.getBindingOperation();
            if (wsdlBindingOperation != null && (namespaceURI = wsdlBindingOperation.getNamespaceURI()) != null) {
                opQName = new QName(namespaceURI, opName);
            }
            String javaName = opName.substring(0, 1).toLowerCase() + opName.substring(1);
            ServiceEndpointMethodMapping seiMethodMapping = null;
            if (seiMapping != null) {
                epMetaData.setServiceEndpointInterfaceName(seiMapping.getServiceEndpointInterface());
                seiMethodMapping = seiMapping.getServiceEndpointMethodMappingByWsdlOperation(opName);
                if (seiMethodMapping == null) {
                    throw NativeMessages.MESSAGES.cannotObtainMethodMappingFor(opQName);
                }
                javaName = seiMethodMapping.getJavaMethodName();
            }
            OperationMetaData opMetaData = new OperationMetaData(epMetaData, opQName, javaName);
            epMetaData.addOperation(opMetaData);
            String style = wsdlOperation.getStyle();
            epMetaData.setStyle("http://www.w3.org/2004/03/wsdl/style/iri".equals(style) ? Style.DOCUMENT : Style.RPC);
            if ("http://www.w3.org/2004/08/wsdl/in-only".equals(wsdlOperation.getPattern())) {
                opMetaData.setOneWay(true);
            }
            if (wsdlBindingOperation != null) {
                opMetaData.setSOAPAction(wsdlBindingOperation.getSOAPAction());
            }
            String encStyle = epMetaData.getEncodingStyle().toURI();
            TypeMappingRegistryImpl tmRegistry = new TypeMappingRegistryImpl();
            TypeMappingImpl typeMapping = (TypeMappingImpl)tmRegistry.getTypeMapping(encStyle);
            if (opMetaData.getStyle() == Style.RPC) {
                this.buildParameterMetaDataRpc(opMetaData, wsdlOperation, seiMethodMapping, typeMapping);
            } else {
                this.buildParameterMetaDataDoc(opMetaData, wsdlOperation, seiMethodMapping, typeMapping);
            }
            this.buildFaultMetaData(opMetaData, wsdlOperation);
        }
    }

    private ParameterMetaData buildInputParameter(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping, String partName, QName xmlName, QName xmlType, int pos, boolean optional) {
        String nsURI;
        String packageName;
        WSDLRPCSignatureItem item = wsdlOperation.getRpcSignatureitem(partName);
        if (item != null) {
            pos = item.getPosition();
        }
        String javaTypeName = typeMapping.getJavaTypeName(xmlType);
        boolean mapped = false;
        if (seiMethodMapping != null) {
            MethodParamPartsMapping paramMapping = seiMethodMapping.getMethodParamPartsMappingByPartName(partName);
            if (paramMapping != null) {
                javaTypeName = paramMapping.getParamType();
                pos = paramMapping.getParamPosition();
                mapped = true;
            } else if (!optional) {
                throw NativeMessages.MESSAGES.cannotObtainMethodParameterMappingFor(partName, seiMethodMapping.getWsdlOperation());
            }
        }
        if (!mapped && optional) {
            return null;
        }
        JavaWsdlMapping javaWsdlMapping = opMetaData.getEndpointMetaData().getServiceMetaData().getJavaWsdlMapping();
        if (javaTypeName == null && javaWsdlMapping != null && (packageName = javaWsdlMapping.getPackageNameForNamespaceURI(xmlType.getNamespaceURI())) != null) {
            javaTypeName = packageName + "." + xmlType.getLocalPart();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Guess java type from package mapping: [xmlType=" + xmlType + " javaType=" + javaTypeName + "]"));
            }
        }
        if (javaTypeName == null) {
            throw NativeMessages.MESSAGES.cannotObtainJavaTypeMappingFor(xmlType);
        }
        ParameterMetaData inMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
        inMetaData.setPartName(partName);
        inMetaData.setIndex(pos);
        opMetaData.addParameter(inMetaData);
        TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        if (typesMetaData.getTypeMappingByXMLType(xmlType) == null && !"http://www.w3.org/2001/XMLSchema".equals(nsURI = xmlType.getNamespaceURI()) && !"http://schemas.xmlsoap.org/soap/encoding/".equals(nsURI)) {
            TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
            typesMetaData.addTypeMapping(tmMetaData);
        }
        return inMetaData;
    }

    private ParameterMetaData buildOutputParameter(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, int pos, String partName, QName xmlName, QName xmlType, TypeMappingImpl typeMapping, boolean optional) {
        String nsURI;
        String packageName;
        boolean hasReturnMapping = opMetaData.getReturnParameter() == null;
        WSDLRPCSignatureItem item = wsdlOperation.getRpcSignatureitem(partName);
        if (item != null) {
            hasReturnMapping = item.getDirection() == WSDLRPCSignatureItem.Direction.RETURN;
            pos = item.getPosition();
        }
        String javaTypeName = typeMapping.getJavaTypeName(xmlType);
        boolean mapped = false;
        if (seiMethodMapping != null) {
            MethodParamPartsMapping paramMapping = seiMethodMapping.getMethodParamPartsMappingByPartName(partName);
            if (paramMapping != null) {
                javaTypeName = paramMapping.getParamType();
                pos = paramMapping.getParamPosition();
                hasReturnMapping = false;
                mapped = true;
            } else {
                String mappingPart;
                WsdlReturnValueMapping returnMapping = seiMethodMapping.getWsdlReturnValueMapping();
                if (returnMapping != null && (mappingPart = returnMapping.getWsdlMessagePartName()) != null && partName.equals(mappingPart)) {
                    javaTypeName = returnMapping.getMethodReturnValue();
                    hasReturnMapping = true;
                    mapped = true;
                }
            }
        }
        if (!mapped && optional) {
            return null;
        }
        JavaWsdlMapping javaWsdlMapping = opMetaData.getEndpointMetaData().getServiceMetaData().getJavaWsdlMapping();
        if (javaTypeName == null && javaWsdlMapping != null && (packageName = javaWsdlMapping.getPackageNameForNamespaceURI(xmlType.getNamespaceURI())) != null) {
            javaTypeName = packageName + "." + xmlType.getLocalPart();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Guess java type from package mapping: [xmlType=" + xmlType + " javaType=" + javaTypeName + "]"));
            }
        }
        if (javaTypeName == null) {
            throw NativeMessages.MESSAGES.cannotObtainJavaTypeMappingFor(xmlType);
        }
        ParameterMetaData outMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
        outMetaData.setPartName(partName);
        if (hasReturnMapping) {
            opMetaData.setReturnParameter(outMetaData);
        } else {
            outMetaData.setIndex(pos);
            outMetaData.setMode(ParameterMode.OUT);
            opMetaData.addParameter(outMetaData);
        }
        TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        if (typesMetaData.getTypeMappingByXMLType(xmlType) == null && !"http://www.w3.org/2001/XMLSchema".equals(nsURI = xmlType.getNamespaceURI()) && !"http://schemas.xmlsoap.org/soap/encoding/".equals(nsURI)) {
            TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
            typesMetaData.addTypeMapping(tmMetaData);
        }
        this.setupSOAPArrayParameter(outMetaData);
        return outMetaData;
    }

    private int processBindingParameters(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping, WSDLBindingOperation bindingOperation, int wsdlPosition) {
        ParameterMetaData pmd;
        WSDLBindingOperationInput bindingInput = bindingOperation.getInputs()[0];
        for (WSDLSOAPHeader header : bindingInput.getSoapHeaders()) {
            QName xmlName = header.getElement();
            QName xmlType = this.lookupSchemaType(wsdlOperation, xmlName);
            String partName = header.getPartName();
            pmd = this.buildInputParameter(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, partName, xmlName, xmlType, wsdlPosition++, !header.isIncludeInSignature());
            if (pmd == null) continue;
            pmd.setInHeader(true);
        }
        for (WSDLMIMEPart mimePart : bindingInput.getMimeParts()) {
            String partName = mimePart.getPartName();
            QName xmlName = new QName(partName);
            QName xmlType = mimePart.getXmlType();
            pmd = this.buildInputParameter(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, partName, xmlName, xmlType, wsdlPosition++, false);
            pmd.setSwA(true);
            pmd.setMimeTypes(mimePart.getMimeTypes());
        }
        return wsdlPosition;
    }

    private int processBindingOutputParameters(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping, WSDLBindingOperation bindingOperation, int wsdlPosition) {
        ParameterMetaData pmd;
        QName xmlType;
        ParameterMetaData outMetaData;
        QName xmlName;
        String partName;
        WSDLBindingOperationOutput bindingOutput = bindingOperation.getOutputs()[0];
        for (WSDLSOAPHeader header : bindingOutput.getSoapHeaders()) {
            partName = header.getPartName();
            xmlName = header.getElement();
            outMetaData = opMetaData.getParameter(xmlName);
            if (outMetaData != null) {
                outMetaData.setMode(ParameterMode.INOUT);
                continue;
            }
            xmlType = this.lookupSchemaType(wsdlOperation, xmlName);
            pmd = this.buildOutputParameter(opMetaData, wsdlOperation, seiMethodMapping, wsdlPosition, partName, xmlName, xmlType, typeMapping, !header.isIncludeInSignature());
            if (pmd == null) continue;
            pmd.setInHeader(true);
            if (opMetaData.getReturnParameter() == pmd) continue;
            ++wsdlPosition;
        }
        for (WSDLMIMEPart mimePart : bindingOutput.getMimeParts()) {
            partName = mimePart.getPartName();
            xmlName = new QName(partName);
            outMetaData = opMetaData.getParameter(xmlName);
            if (outMetaData != null) {
                outMetaData.setMode(ParameterMode.INOUT);
                continue;
            }
            xmlType = mimePart.getXmlType();
            pmd = this.buildOutputParameter(opMetaData, wsdlOperation, seiMethodMapping, wsdlPosition, partName, xmlName, xmlType, typeMapping, false);
            pmd.setSwA(true);
            pmd.setMimeTypes(mimePart.getMimeTypes());
            if (opMetaData.getReturnParameter() == pmd) continue;
            ++wsdlPosition;
        }
        return wsdlPosition;
    }

    private void setupSOAPArrayParameter(ParameterMetaData paramMetaData) {
        Use use = paramMetaData.getOperationMetaData().getUse();
        String xmlTypeLocalPart = paramMetaData.getXmlType().getLocalPart();
        if (use == Use.ENCODED && xmlTypeLocalPart.indexOf("ArrayOf") >= 0) {
            paramMetaData.setSOAPArrayParam(true);
            try {
                boolean isBase64;
                boolean isSoapEnc;
                TypeMappingImpl typeMapping;
                QName compXMLType;
                String javaTypeName = paramMetaData.getJavaTypeName();
                Class javaType = JavaUtils.loadJavaType((String)javaTypeName);
                Class<?> compJavaType = javaType.getComponentType();
                if (xmlTypeLocalPart.indexOf("ArrayOfArrayOf") >= 0) {
                    compJavaType = compJavaType.getComponentType();
                }
                if ((compXMLType = (typeMapping = (isSoapEnc = xmlTypeLocalPart.toLowerCase().indexOf("soapenc") > 0) ? new EncodedTypeMapping() : new LiteralTypeMapping()).getXMLType(compJavaType)) != null && (isBase64 = compXMLType.getLocalPart().startsWith("base64")) && xmlTypeLocalPart.toLowerCase().indexOf("hex") > 0) {
                    compXMLType = isSoapEnc ? Constants.TYPE_SOAP11_HEXBINARY : Constants.TYPE_LITERAL_HEXBINARY;
                }
                paramMetaData.setSOAPArrayCompType(compXMLType);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }

    private Map<String, String> createVariableMappingMap(VariableMapping[] mappings) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (mappings != null) {
            for (VariableMapping mapping : mappings) {
                map.put(mapping.getXmlElementName(), mapping.getJavaVariableName());
            }
        }
        return map;
    }

    private void buildParameterMetaDataRpc(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping) {
        this.log.trace((Object)("buildParameterMetaDataRpc: " + opMetaData.getQName()));
        WSDLBindingOperation bindingOperation = wsdlOperation.getBindingOperation();
        if (bindingOperation == null) {
            throw NativeMessages.MESSAGES.cannotLocateBindingOperationFor(opMetaData.getQName());
        }
        WSDLInterfaceOperationInput input = wsdlOperation.getInputs()[0];
        int wsdlPosition = 0;
        for (WSDLRPCPart part : input.getChildParts()) {
            QName xmlType = part.getType();
            String partName = part.getName();
            QName xmlName = new QName(partName);
            ParameterMetaData pmd = this.buildInputParameter(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, partName, xmlName, xmlType, wsdlPosition++, false);
            this.setupSOAPArrayParameter(pmd);
        }
        wsdlPosition = this.processBindingParameters(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, bindingOperation, wsdlPosition);
        WSDLInterfaceOperationOutput[] outputs = wsdlOperation.getOutputs();
        if (outputs.length > 0) {
            WSDLInterfaceOperationOutput output = outputs[0];
            for (WSDLRPCPart part : output.getChildParts()) {
                String partName = part.getName();
                ParameterMetaData outMetaData = opMetaData.getParameter(new QName(partName));
                if (outMetaData != null) {
                    outMetaData.setMode(ParameterMode.INOUT);
                    continue;
                }
                QName xmlName = new QName(partName);
                QName xmlType = part.getType();
                ParameterMetaData pmd = this.buildOutputParameter(opMetaData, wsdlOperation, seiMethodMapping, wsdlPosition, partName, xmlName, xmlType, typeMapping, false);
                if (opMetaData.getReturnParameter() != pmd) {
                    ++wsdlPosition;
                }
                this.setupSOAPArrayParameter(pmd);
            }
            this.processBindingOutputParameters(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, bindingOperation, wsdlPosition);
        } else if (wsdlOperation.getPattern() != "http://www.w3.org/2004/08/wsdl/in-only") {
            throw NativeMessages.MESSAGES.rpcStyleMissingOutputAndNotAInOnlyMEP();
        }
    }

    private int processDocElement(OperationMetaData operation, WSDLInterfaceOperation wsdlOperation, WSDLBindingOperation bindingOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping, List<WrappedParameter> wrappedParameters, List<WrappedParameter> wrappedResponseParameters) {
        int wsdlPosition;
        WSDLInterfaceOperationInput input = wsdlOperation.getInputs()[0];
        WSDLBindingOperationInput bindingInput = bindingOperation.getInputs()[0];
        QName xmlName = input.getElement();
        QName xmlType = input.getXMLType();
        String javaTypeName = typeMapping.getJavaTypeName(xmlType);
        TypesMetaData typesMetaData = operation.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        TypeMappingMetaData typeMetaData = typesMetaData.getTypeMappingByXMLType(xmlType);
        if (typeMetaData != null) {
            javaTypeName = typeMetaData.getJavaTypeName();
        }
        if (javaTypeName == null) {
            throw NativeMessages.MESSAGES.cannotObtainJavaTypeMappingFor(xmlType);
        }
        boolean isWrapped = this.isWrapped(seiMethodMapping, javaTypeName);
        operation.getEndpointMetaData().setWrappedParameterStyle(isWrapped);
        ParameterMetaData inMetaData = new ParameterMetaData(operation, xmlName, xmlType, javaTypeName);
        operation.addParameter(inMetaData);
        if (inMetaData.getOperationMetaData().isDocumentWrapped()) {
            if (seiMethodMapping == null) {
                throw NativeMessages.MESSAGES.cannotWrapParametersWithoutSEIMethodMapping();
            }
            ServiceEndpointInterfaceMapping seiMapping = seiMethodMapping.getServiceEndpointInterfaceMapping();
            JavaXmlTypeMapping javaXmlTypeMapping = seiMapping.getJavaWsdlMapping().getTypeMappingForQName(xmlType);
            if (javaXmlTypeMapping == null) {
                throw NativeMessages.MESSAGES.cannotObtainJavaXmlTypeMappingFor(xmlType);
            }
            Map<String, String> variableMap = this.createVariableMappingMap(javaXmlTypeMapping.getVariableMappings());
            for (MethodParamPartsMapping partMapping : seiMethodMapping.getMethodParamPartsMappings()) {
                String elementName;
                WsdlMessageMapping wsdlMessageMapping = partMapping.getWsdlMessageMapping();
                if (wsdlMessageMapping.isSoapHeader() || bindingInput.getMimePart(elementName = wsdlMessageMapping.getWsdlMessagePartName()) != null) continue;
                String variable = variableMap.get(elementName);
                if (variable == null) {
                    throw NativeMessages.MESSAGES.couldNotDetermineVariableNameForElement(elementName);
                }
                WrappedParameter wrapped = new WrappedParameter(new QName(elementName), partMapping.getParamType(), variable, partMapping.getParamPosition());
                String parameterMode = wsdlMessageMapping.getParameterMode();
                if (parameterMode == null || parameterMode.length() < 2) {
                    throw NativeMessages.MESSAGES.invalidParameterModeForElement(elementName);
                }
                if (!"OUT".equals(parameterMode)) {
                    wrappedParameters.add(wrapped);
                }
                if ("IN".equals(parameterMode)) continue;
                wrapped.setHolder(true);
                if ("INOUT".equals(parameterMode)) {
                    wrapped = new WrappedParameter(wrapped);
                }
                wrappedResponseParameters.add(wrapped);
            }
            inMetaData.setWrappedParameters(wrappedParameters);
            wsdlPosition = wrappedParameters.size();
        } else {
            MethodParamPartsMapping part;
            if (seiMethodMapping != null && (part = seiMethodMapping.getMethodParamPartsMappingByPartName(input.getPartName())) != null) {
                inMetaData.setJavaTypeName(part.getParamType());
                inMetaData.setIndex(part.getParamPosition());
            }
            wsdlPosition = 1;
        }
        return wsdlPosition;
    }

    private boolean isWrapped(ServiceEndpointMethodMapping seiMethodMapping, String javaTypeName) {
        MethodParamPartsMapping[] partsMappings;
        boolean isWrapParameters = seiMethodMapping != null ? seiMethodMapping.isWrappedElement() : false;
        this.log.trace((Object)("isWrapParameters based on wrapped-element: " + isWrapParameters));
        if (!isWrapParameters && seiMethodMapping != null && (partsMappings = seiMethodMapping.getMethodParamPartsMappings()).length > 0) {
            ArrayList<String> anyTypes = new ArrayList<String>();
            anyTypes.add("javax.xml.soap.SOAPElement");
            anyTypes.add("org.w3c.dom.Element");
            boolean matchingPartFound = false;
            for (MethodParamPartsMapping partsMapping : partsMappings) {
                String methodMappingTypeName = partsMapping.getParamType();
                if (methodMappingTypeName.equals(javaTypeName)) {
                    matchingPartFound = true;
                    break;
                }
                if (anyTypes.contains(javaTypeName) && anyTypes.contains(methodMappingTypeName)) {
                    matchingPartFound = true;
                    break;
                }
                try {
                    Class paramType = JavaUtils.loadJavaType((String)methodMappingTypeName);
                    Class javaType = JavaUtils.loadJavaType((String)javaTypeName);
                    if (!JavaUtils.isAssignableFrom((Class)javaType, (Class)paramType)) continue;
                    matchingPartFound = true;
                    break;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            isWrapParameters = !matchingPartFound;
            this.log.trace((Object)("isWrapParameters based on matching parts: " + isWrapParameters));
        }
        return isWrapParameters;
    }

    private int processOutputDocElement(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping, List<WrappedParameter> wrappedResponseParameters, int wsdlPosition) {
        WSDLInterfaceOperationOutput opOutput = wsdlOperation.getOutputs()[0];
        QName xmlName = opOutput.getElement();
        QName xmlType = opOutput.getXMLType();
        String javaTypeName = typeMapping.getJavaTypeName(xmlType);
        TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        if (typesMetaData.getTypeMappingByXMLType(xmlType) != null) {
            javaTypeName = typesMetaData.getTypeMappingByXMLType(xmlType).getJavaTypeName();
        }
        if (javaTypeName == null) {
            throw NativeMessages.MESSAGES.cannotObtainJavaXmlTypeMappingFor(xmlType);
        }
        ParameterMetaData outMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
        boolean hasReturnMapping = true;
        if (opMetaData.isDocumentWrapped()) {
            if (seiMethodMapping == null) {
                throw NativeMessages.MESSAGES.cannotWrapParametersWithoutSEIMethodMapping();
            }
            WsdlReturnValueMapping returnValueMapping = seiMethodMapping.getWsdlReturnValueMapping();
            if (returnValueMapping != null) {
                ServiceEndpointInterfaceMapping seiMapping = seiMethodMapping.getServiceEndpointInterfaceMapping();
                JavaWsdlMapping javaWsdlMapping = seiMapping.getJavaWsdlMapping();
                JavaXmlTypeMapping javaXmlTypeMapping = javaWsdlMapping.getTypeMappingForQName(xmlType);
                if (javaXmlTypeMapping == null) {
                    throw NativeMessages.MESSAGES.cannotObtainJavaXmlTypeMappingFor(xmlType);
                }
                Map<String, String> map = this.createVariableMappingMap(javaXmlTypeMapping.getVariableMappings());
                if (map.size() > 0) {
                    String elementName = returnValueMapping.getWsdlMessagePartName();
                    String variable = map.get(elementName);
                    if (variable == null) {
                        throw NativeMessages.MESSAGES.couldNotDetermineVariableNameForElement(elementName);
                    }
                    String wrappedType = returnValueMapping.getMethodReturnValue();
                    QName element = new QName(elementName);
                    WrappedParameter wrappedParameter = new WrappedParameter(element, wrappedType, variable, -1);
                    wrappedResponseParameters.add(0, wrappedParameter);
                }
            }
            outMetaData.setWrappedParameters(wrappedResponseParameters);
        } else {
            if (seiMethodMapping != null) {
                MethodParamPartsMapping part = seiMethodMapping.getMethodParamPartsMappingByPartName(opOutput.getPartName());
                String mode = null;
                if (part != null) {
                    WsdlMessageMapping wsdlMessageMapping = part.getWsdlMessageMapping();
                    mode = wsdlMessageMapping.getParameterMode();
                }
                if ("INOUT".equals(mode)) {
                    ParameterMetaData inMetaData = opMetaData.getParameter(xmlName);
                    if (inMetaData != null) {
                        inMetaData.setMode(ParameterMode.INOUT);
                        return wsdlPosition;
                    }
                    throw NativeMessages.MESSAGES.couldNotUpdateInParameterAsIndicated(opOutput.getPartName());
                }
                if ("OUT".equals(mode)) {
                    hasReturnMapping = false;
                    javaTypeName = part.getParamType();
                    outMetaData.setIndex(part.getParamPosition());
                    outMetaData.setJavaTypeName(javaTypeName);
                } else {
                    WsdlReturnValueMapping returnValueMapping = seiMethodMapping.getWsdlReturnValueMapping();
                    if (returnValueMapping != null) {
                        javaTypeName = returnValueMapping.getMethodReturnValue();
                        outMetaData.setJavaTypeName(javaTypeName);
                    }
                }
            }
            this.setupSOAPArrayParameter(outMetaData);
        }
        if (hasReturnMapping) {
            opMetaData.setReturnParameter(outMetaData);
        } else {
            opMetaData.addParameter(outMetaData);
            outMetaData.setMode(ParameterMode.OUT);
            ++wsdlPosition;
        }
        return wsdlPosition;
    }

    private void buildParameterMetaDataDoc(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping) {
        this.log.trace((Object)("buildParameterMetaDataDoc: " + opMetaData.getQName()));
        WSDLBindingOperation bindingOperation = wsdlOperation.getBindingOperation();
        if (bindingOperation == null) {
            throw NativeMessages.MESSAGES.cannotLocateBindingOperationFor(wsdlOperation.getName());
        }
        ArrayList<WrappedParameter> wrappedParameters = new ArrayList<WrappedParameter>();
        ArrayList<WrappedParameter> wrappedResponseParameters = new ArrayList<WrappedParameter>();
        int wsdlPosition = 0;
        if (wsdlOperation.getInputs().length > 0) {
            wsdlPosition = this.processDocElement(opMetaData, wsdlOperation, bindingOperation, seiMethodMapping, typeMapping, wrappedParameters, wrappedResponseParameters);
            wsdlPosition = this.processBindingParameters(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, bindingOperation, wsdlPosition);
        } else {
            opMetaData.getEndpointMetaData().setWrappedParameterStyle(Boolean.FALSE);
        }
        if (wsdlOperation.getOutputs().length > 0) {
            wsdlPosition = this.processOutputDocElement(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, wrappedResponseParameters, wsdlPosition);
            wsdlPosition = this.processBindingOutputParameters(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, bindingOperation, wsdlPosition);
        }
    }
}

