/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.utils;

import java.util.ResourceBundle;
import org.jboss.ws.core.soap.BundleUtils;

public class Style {
    private static final ResourceBundle bundle = BundleUtils.getBundle(Style.class);
    private String style;
    public static final Style RPC = new Style("rpc");
    public static final Style DOCUMENT = new Style("document");

    private Style(String style) {
        this.style = style;
    }

    public static Style getDefaultStyle() {
        return DOCUMENT;
    }

    public static Style valueOf(String style) {
        if (Style.RPC.style.equals(style)) {
            return RPC;
        }
        if (Style.DOCUMENT.style.equals(style)) {
            return DOCUMENT;
        }
        throw new IllegalArgumentException(BundleUtils.getMessage(bundle, "UNSUPPORTED_STYLE", style));
    }

    public String toString() {
        return this.style;
    }
}

