/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import org.jboss.ws.core.server.MimeHeaderSource;

public class ServletHeaderSource
implements MimeHeaderSource {
    private HttpServletRequest req;
    private HttpServletResponse res;

    public ServletHeaderSource(HttpServletRequest req, HttpServletResponse res) {
        this.req = req;
        this.res = res;
    }

    @Override
    public MimeHeaders getMimeHeaders() {
        Enumeration e = this.req.getHeaderNames();
        if (e == null) {
            return null;
        }
        MimeHeaders headers = new MimeHeaders();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            headers.addHeader(name, this.req.getHeader(name));
        }
        return headers;
    }

    public Map<String, List<String>> getHeaderMap() {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        Enumeration e = this.req.getHeaderNames();
        if (e != null) {
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                ArrayList<String> values = new ArrayList<String>();
                values.add(this.req.getHeader(name));
                headerMap.put(name, values);
            }
        }
        return headerMap;
    }

    @Override
    public void setMimeHeaders(MimeHeaders headers) {
        Iterator i = headers.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader header = (MimeHeader)i.next();
            this.res.addHeader(header.getName(), header.getValue());
        }
    }

    public void setHeaderMap(Map<String, List<String>> headers) {
        for (String name : headers.keySet()) {
            List<String> values = headers.get(name);
            for (String value : values) {
                this.res.addHeader(name, value);
            }
        }
    }
}

