/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.transform.Result;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.binding.SerializerSupport;
import org.jboss.ws.util.xml.BufferedStreamResult;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SOAPElementSerializer
extends SerializerSupport {
    private static final Logger log = Logger.getLogger(SOAPElementSerializer.class);

    @Override
    public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException {
        log.debug((Object)("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        if (value == null) {
            throw NativeMessages.MESSAGES.illegalNullArgument("value");
        }
        if (!(value instanceof SOAPElement)) {
            throw NativeMessages.MESSAGES.valueIsNotA(SOAPElement.class, value.getClass());
        }
        String xmlFragment = DOMWriter.printNode((Node)((SOAPElement)value), (boolean)false);
        return new BufferedStreamResult(xmlFragment);
    }
}

