/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.core.CommonSOAPBinding;
import org.jboss.ws.core.soap.SOAPFaultImpl;
import org.jboss.ws.core.soap.utils.SOAPUtils;
import org.jboss.ws.metadata.umdm.OperationMetaData;

public abstract class CommonSOAP12Binding
extends CommonSOAPBinding {
    private MessageFactory msgFactory = SOAPUtils.newSOAP12MessageFactory();

    @Override
    protected SOAPMessage createMessage(OperationMetaData opMetaData) throws SOAPException {
        return this.msgFactory.createMessage();
    }

    protected abstract Set<String> getRoles();

    @Override
    protected void verifyUnderstoodHeader(SOAPHeaderElement element) throws Exception {
        boolean isActor;
        QName name = new QName(element.getNamespaceURI(), element.getLocalName());
        String actor = element.getActor();
        Set<String> roles = this.getRoles();
        boolean bl = isActor = actor == null || actor.length() == 0 || "http://schemas.xmlsoap.org/soap/actor/next".equals(actor) || roles.contains(actor);
        if (isActor && !this.headerSource.getHeaders().contains(name)) {
            QName faultCode = SOAPConstants.SOAP_MUSTUNDERSTAND_FAULT;
            SOAPFaultImpl fault = new SOAPFaultImpl();
            fault.setFaultCode(faultCode);
            fault.setFaultString("SOAP header blocks not understood");
            this.throwFaultException(fault);
        }
    }
}

