/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Service;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardEngineValve;
import org.apache.catalina.core.StandardService;
import org.apache.tomcat.util.Constants;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.web.CatalinaLogger;
import org.jboss.web.CatalinaMessages;

public class StandardEngine
extends ContainerBase
implements Engine {
    private String defaultHost = null;
    private static final String info = "org.apache.catalina.core.StandardEngine/1.0";
    private Service service = null;
    private String baseDir = null;
    private String jvmRouteId;
    private boolean initialized = false;

    public StandardEngine() {
        this.pipeline.setBasic(new StandardEngineValve());
        try {
            this.setJvmRoute(System.getProperty("jvmRoute"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.backgroundProcessorDelay = 10;
    }

    @Override
    public String getDefaultHost() {
        return this.defaultHost;
    }

    @Override
    public void setDefaultHost(String host) {
        String oldDefaultHost = this.defaultHost;
        this.defaultHost = host == null ? null : host.toLowerCase(Locale.ENGLISH);
        this.support.firePropertyChange("defaultHost", oldDefaultHost, this.defaultHost);
    }

    @Override
    public void setName(String name) {
        if (this.domain != null) {
            super.setName(this.domain);
            return;
        }
        this.domain = name;
        super.setName(name);
    }

    @Override
    public void setJvmRoute(String routeId) {
        this.jvmRouteId = routeId;
    }

    @Override
    public String getJvmRoute() {
        return this.jvmRouteId;
    }

    @Override
    public Service getService() {
        return this.service;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    public String getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.base");
        }
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.home");
        }
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public void addChild(Container child) {
        if (!(child instanceof Host)) {
            throw CatalinaMessages.MESSAGES.engineChildMustBeHost();
        }
        super.addChild(child);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setParent(Container container) {
        throw CatalinaMessages.MESSAGES.engineHasNoParent();
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (Constants.ENABLE_MODELER && this.oname == null) {
            try {
                if (this.domain == null) {
                    this.domain = this.getName();
                }
                this.controller = this.oname = new ObjectName(this.domain + ":type=Engine");
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Throwable t) {
                CatalinaLogger.CORE_LOGGER.failedEngineJmxRegistration(this.oname, t);
            }
        }
        if (this.service == null) {
            try {
                this.service = new StandardService();
                this.service.setContainer(this);
                this.service.initialize();
            }
            catch (Throwable t) {
                CatalinaLogger.CORE_LOGGER.failedServiceCreation(t);
            }
        }
    }

    @Override
    public void destroy() throws LifecycleException {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        ((StandardService)this.service).destroy();
        if (Constants.ENABLE_MODELER) {
            if (this.oname != null) {
                try {
                    if (this.controller == this.oname) {
                        Registry.getRegistry(null, null).unregisterComponent(this.oname);
                    }
                }
                catch (Throwable t) {
                    CatalinaLogger.CORE_LOGGER.failedContainerJmxUnregistration(this.oname, t);
                }
            }
            Registry.getRegistry(null, null).resetMetadata();
        }
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        super.start();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardEngine[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        super.preRegister(server, name);
        this.setName(name.getDomain());
        return name;
    }

    @Override
    public ObjectName getParentName() throws MalformedObjectNameException {
        if (this.getService() == null) {
            return null;
        }
        String name = this.getService().getName();
        ObjectName serviceName = new ObjectName(this.domain + ":type=Service,serviceName=" + name);
        return serviceName;
    }

    @Override
    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        return new ObjectName(domain + ":type=Engine");
    }

    @Override
    public String getDomain() {
        if (this.domain != null) {
            return this.domain;
        }
        return this.getName();
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }
}

