/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.catalina;

import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.container.catalina.RequestListenerValveFactory;

public class CatalinaContext
implements Context {
    private final RequestListenerValveFactory valveFactory;
    protected final org.apache.catalina.Context context;
    protected final Host host;

    public CatalinaContext(org.apache.catalina.Context context, Host host, RequestListenerValveFactory valveFactory) {
        this.context = context;
        this.host = host;
        this.valveFactory = valveFactory;
    }

    public Host getHost() {
        return this.host;
    }

    public String getPath() {
        return this.context.getPath();
    }

    public boolean isStarted() {
        return this.context.getAvailable();
    }

    public void addRequestListener(ServletRequestListener listener) {
        if (this.valveFactory != null) {
            this.context.getPipeline().addValve(this.valveFactory.createValve(listener));
        }
    }

    public void removeRequestListener(ServletRequestListener listener) {
        if (this.valveFactory != null) {
            Valve listenerValve = this.valveFactory.createValve(listener);
            Pipeline pipeline = this.context.getPipeline();
            for (Valve valve : pipeline.getValves()) {
                if (!listenerValve.equals(valve)) continue;
                pipeline.removeValve(valve);
                break;
            }
        }
    }

    public int getActiveSessionCount() {
        return this.context.getManager().getActiveSessions();
    }

    public boolean isDistributable() {
        return this.context.getManager().getDistributable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(HttpSessionListener listener) {
        org.apache.catalina.Context context = this.context;
        synchronized (context) {
            this.context.setApplicationLifecycleListeners(this.addListener(listener, this.context.getApplicationLifecycleListeners()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(HttpSessionListener listener) {
        org.apache.catalina.Context context = this.context;
        synchronized (context) {
            this.context.setApplicationLifecycleListeners(this.removeListener(listener, this.context.getApplicationLifecycleListeners()));
        }
    }

    private Object[] addListener(Object listener, Object[] listeners) {
        if (listeners == null) {
            return new Object[]{listener};
        }
        ArrayList<Object> listenerList = new ArrayList<Object>(listeners.length + 1);
        listenerList.add(listener);
        listenerList.addAll(Arrays.asList(listeners));
        return listenerList.toArray();
    }

    private Object[] removeListener(Object listener, Object[] listeners) {
        if (listeners == null) {
            return null;
        }
        ArrayList<Object> listenerList = new ArrayList<Object>(listeners.length - 1);
        for (Object existingListener : listeners) {
            if (existingListener.equals(listener)) continue;
            listenerList.add(existingListener);
        }
        return listenerList.toArray();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CatalinaContext)) {
            return false;
        }
        CatalinaContext context = (CatalinaContext)object;
        return this.context == context.context;
    }

    public int hashCode() {
        return this.context.hashCode();
    }

    public String toString() {
        return this.context.getPath();
    }
}

