/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.management;

import javax.management.ObjectName;
import org.hornetq.api.core.SimpleString;

public final class ObjectNameBuilder {
    public static final ObjectNameBuilder DEFAULT = new ObjectNameBuilder("org.hornetq");
    static final String JMS_MODULE = "JMS";
    static final String CORE_MODULE = "Core";
    private final String domain;

    public static ObjectNameBuilder create(String domain) {
        if (domain == null) {
            return new ObjectNameBuilder("org.hornetq");
        }
        return new ObjectNameBuilder(domain);
    }

    private ObjectNameBuilder(String domain) {
        this.domain = domain;
    }

    public ObjectName getHornetQServerObjectName() throws Exception {
        return ObjectName.getInstance(this.domain + ":module=Core,type=Server");
    }

    public ObjectName getAddressObjectName(SimpleString address) throws Exception {
        return this.createObjectName(CORE_MODULE, "Address", address.toString());
    }

    public ObjectName getQueueObjectName(SimpleString address, SimpleString name) throws Exception {
        return ObjectName.getInstance(String.format("%s:module=%s,type=%s,address=%s,name=%s", this.domain, CORE_MODULE, "Queue", ObjectName.quote(address.toString()), ObjectName.quote(name.toString())));
    }

    public ObjectName getDivertObjectName(String name) throws Exception {
        return this.createObjectName(CORE_MODULE, "Divert", name.toString());
    }

    public ObjectName getAcceptorObjectName(String name) throws Exception {
        return this.createObjectName(CORE_MODULE, "Acceptor", name);
    }

    public ObjectName getBroadcastGroupObjectName(String name) throws Exception {
        return this.createObjectName(CORE_MODULE, "BroadcastGroup", name);
    }

    public ObjectName getBridgeObjectName(String name) throws Exception {
        return this.createObjectName(CORE_MODULE, "Bridge", name);
    }

    public ObjectName getClusterConnectionObjectName(String name) throws Exception {
        return this.createObjectName(CORE_MODULE, "ClusterConnection", name);
    }

    public ObjectName getDiscoveryGroupObjectName(String name) throws Exception {
        return this.createObjectName(CORE_MODULE, "DiscoveryGroup", name);
    }

    public ObjectName getJMSServerObjectName() throws Exception {
        return ObjectName.getInstance(this.domain + ":module=JMS,type=Server");
    }

    public ObjectName getJMSQueueObjectName(String name) throws Exception {
        return this.createObjectName(JMS_MODULE, "Queue", name);
    }

    public ObjectName getJMSTopicObjectName(String name) throws Exception {
        return this.createObjectName(JMS_MODULE, "Topic", name);
    }

    public ObjectName getConnectionFactoryObjectName(String name) throws Exception {
        return this.createObjectName(JMS_MODULE, "ConnectionFactory", name);
    }

    private ObjectName createObjectName(String module, String type, String name) throws Exception {
        return ObjectName.getInstance(String.format("%s:module=%s,type=%s,name=%s", this.domain, module, type, ObjectName.quote(name)));
    }
}

