/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security.jaspi;

import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.MessageInfo;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.security.jaspi.WebJASPICallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.security.auth.message.GenericMessageInfo;
import org.jboss.security.plugins.auth.JASPIServerAuthenticationManager;

public class WebJASPIOptionalAuthenticator
extends ValveBase {
    private static Logger log = Logger.getLogger((String)"org.jboss.as.web.security");

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Realm realm = this.getContainer().getRealm();
        if (realm.findSecurityConstraints(request, (Context)this.getContainer()) == null) {
            log.tracef("Invoking optional JASPI authenticator for request context %s", (Object)request.getServletPath());
            GenericMessageInfo messageInfo = new GenericMessageInfo();
            messageInfo.setRequestMessage((Object)request);
            messageInfo.setResponseMessage((Object)request.getResponse());
            messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", "false");
            WebJASPICallbackHandler cbh = new WebJASPICallbackHandler();
            JASPIServerAuthenticationManager sam = new JASPIServerAuthenticationManager();
            String appContext = request.getLocalName() + " " + request.getContextPath();
            String messageLayer = "HttpServlet";
            boolean isValid = sam.isValid((MessageInfo)messageInfo, new Subject(), messageLayer, appContext, (CallbackHandler)cbh);
            if (isValid) {
                WebLogger.WEB_SECURITY_LOGGER.debugf("JASPI validation for unprotected request context %s succeeded", request.getServletPath());
                sam.secureResponse((MessageInfo)messageInfo, new Subject(), messageLayer, appContext, (CallbackHandler)cbh);
            } else {
                WebLogger.WEB_SECURITY_LOGGER.failJASPIValidation(request.getServletPath());
            }
        }
        super.getNext().invoke(request, response);
    }
}

