/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.AliasOperationTransformer;
import org.jboss.as.controller.transform.CombinedTransformer;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.RejectExpressionValuesChainedTransformer;
import org.jboss.as.controller.transform.RejectExpressionValuesTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.controller.transform.chained.ChainedOperationTransformer;
import org.jboss.as.controller.transform.chained.ChainedResourceTransformer;
import org.jboss.as.controller.transform.chained.ChainedResourceTransformerEntry;
import org.jboss.as.web.DefaultJsfProfileCompletionHandler;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebAccessLogDefinition;
import org.jboss.as.web.WebAccessLogDirectoryDefinition;
import org.jboss.as.web.WebConnectorDefinition;
import org.jboss.as.web.WebContainerDefinition;
import org.jboss.as.web.WebDefinition;
import org.jboss.as.web.WebDeploymentDefinition;
import org.jboss.as.web.WebDeploymentServletDefinition;
import org.jboss.as.web.WebJSPDefinition;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebReWriteConditionDefinition;
import org.jboss.as.web.WebReWriteDefinition;
import org.jboss.as.web.WebSSLDefinition;
import org.jboss.as.web.WebSSODefinition;
import org.jboss.as.web.WebStaticResources;
import org.jboss.as.web.WebSubsystemParser;
import org.jboss.as.web.WebValveDefinition;
import org.jboss.as.web.WebVirtualHostDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class WebExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "web";
    public static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"web");
    protected static final PathElement CONNECTOR_PATH = PathElement.pathElement((String)"connector");
    protected static final PathElement SSL_PATH = PathElement.pathElement((String)"configuration", (String)"ssl");
    protected static final PathElement SSL_ALIAS = PathElement.pathElement((String)"ssl", (String)"configuration");
    protected static final PathElement HOST_PATH = PathElement.pathElement((String)"virtual-server");
    protected static final PathElement JSP_CONFIGURATION_PATH = PathElement.pathElement((String)"configuration", (String)"jsp-configuration");
    protected static final PathElement STATIC_RESOURCES_PATH = PathElement.pathElement((String)"configuration", (String)"static-resources");
    protected static final PathElement CONTAINER_PATH = PathElement.pathElement((String)"configuration", (String)"container");
    protected static final PathElement ACCESS_LOG_PATH = PathElement.pathElement((String)"configuration", (String)"access-log");
    protected static final PathElement ACCESS_LOG_ALIAS = PathElement.pathElement((String)"access-log", (String)"configuration");
    protected static final PathElement REWRITE_PATH = PathElement.pathElement((String)"rewrite");
    protected static final PathElement SSO_PATH = PathElement.pathElement((String)"configuration", (String)"sso");
    protected static final PathElement SSO_ALIAS = PathElement.pathElement((String)"sso", (String)"configuration");
    protected static final PathElement DIRECTORY_PATH = PathElement.pathElement((String)"setting", (String)"directory");
    protected static final PathElement DIRECTORY_ALIAS = PathElement.pathElement((String)"directory", (String)"configuration");
    protected static final PathElement REWRITECOND_PATH = PathElement.pathElement((String)"condition");
    protected static final PathElement VALVE_PATH = PathElement.pathElement((String)"valve");
    protected static final PathElement PARAM = PathElement.pathElement((String)"param");
    private static final String RESOURCE_NAME = WebExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        String prefix = SUBSYSTEM_NAME + (keyPrefix == null ? "" : "." + keyPrefix);
        return new StandardResourceDescriptionResolver(prefix, RESOURCE_NAME, WebExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)WebDefinition.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)WebSubsystemParser.getInstance());
        ManagementResourceRegistration connectors = registration.registerSubModel((ResourceDefinition)WebConnectorDefinition.INSTANCE);
        ManagementResourceRegistration ssl = connectors.registerSubModel((ResourceDefinition)WebSSLDefinition.INSTANCE);
        connectors.registerAlias(SSL_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(ssl));
        ManagementResourceRegistration hosts = registration.registerSubModel((ResourceDefinition)WebVirtualHostDefinition.INSTANCE);
        ManagementResourceRegistration accesslog = hosts.registerSubModel((ResourceDefinition)WebAccessLogDefinition.INSTANCE);
        hosts.registerAlias(ACCESS_LOG_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(accesslog));
        ManagementResourceRegistration accessLogDir = accesslog.registerSubModel((ResourceDefinition)WebAccessLogDirectoryDefinition.INSTANCE);
        accesslog.registerAlias(DIRECTORY_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(accessLogDir));
        ManagementResourceRegistration sso = hosts.registerSubModel((ResourceDefinition)WebSSODefinition.INSTANCE);
        hosts.registerAlias(SSO_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(sso));
        ManagementResourceRegistration rewrite = hosts.registerSubModel((ResourceDefinition)WebReWriteDefinition.INSTANCE);
        rewrite.registerSubModel((ResourceDefinition)WebReWriteConditionDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebJSPDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebStaticResources.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebContainerDefinition.INSTANCE);
        ManagementResourceRegistration deployments = subsystem.registerDeploymentModel((ResourceDefinition)WebDeploymentDefinition.INSTANCE);
        deployments.registerSubModel((ResourceDefinition)WebDeploymentServletDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebValveDefinition.INSTANCE);
        if (context.isRegisterTransformers()) {
            this.registerTransformers_1_1_0(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace ns : Namespace.values()) {
            if (ns.getUriString() == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, ns.getUriString(), (XMLElementReader)WebSubsystemParser.getInstance());
        }
        context.setProfileParsingCompletionHandler((ProfileParsingCompletionHandler)new DefaultJsfProfileCompletionHandler());
    }

    private void registerTransformers_1_1_0(SubsystemRegistration registration) {
        int defaultRedirectPort = 443;
        TransformersSubRegistration transformers = registration.registerModelTransformers((ModelVersionRange)ModelVersion.create((int)1, (int)1, (int)0), ResourceTransformer.DEFAULT);
        transformers.registerSubResource(VALVE_PATH, true);
        WebExtension.rejectExpressions(transformers, JSP_CONFIGURATION_PATH, (AttributeDefinition[])WebJSPDefinition.JSP_ATTRIBUTES);
        WebExtension.rejectExpressions(transformers, STATIC_RESOURCES_PATH, (AttributeDefinition[])WebStaticResources.STATIC_ATTRIBUTES);
        WebExtension.rejectExpressions(transformers, CONTAINER_PATH, WebContainerDefinition.CONTAINER_ATTRIBUTES);
        RejectExpressionValuesChainedTransformer reject = new RejectExpressionValuesChainedTransformer((AttributeDefinition[])WebConnectorDefinition.CONNECTOR_ATTRIBUTES);
        TransformersSubRegistration connectors = transformers.registerSubResource(CONNECTOR_PATH, (ResourceTransformer)new ChainedResourceTransformer(new ChainedResourceTransformerEntry[]{reject}));
        connectors.registerOperationTransformer("add", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                ModelNode transformedOperation;
                if (!operation.hasDefined(WebConnectorDefinition.REDIRECT_PORT.getName())) {
                    transformedOperation = operation.clone();
                    transformedOperation.get(WebConnectorDefinition.REDIRECT_PORT.getName()).set(443);
                } else {
                    transformedOperation = operation;
                }
                final boolean hasDefinedVirtualServer = operation.hasDefined("virtual-server");
                return new OperationTransformer.TransformedOperation(transformedOperation, new OperationRejectionPolicy(){

                    public boolean rejectOperation(ModelNode preparedResult) {
                        return hasDefinedVirtualServer;
                    }

                    public String getFailureDescription() {
                        return WebMessages.MESSAGES.transformationVersion_1_1_0_JBPAPP_9314();
                    }
                }, OperationResultTransformer.ORIGINAL_RESULT);
            }
        }, reject}));
        connectors.registerOperationTransformer("write-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                ModelNode transformedOperation;
                String attributeName = operation.get("name").asString();
                if (WebConnectorDefinition.REDIRECT_PORT.getName().equals(attributeName) && !operation.hasDefined("value")) {
                    transformedOperation = operation.clone();
                    transformedOperation.get("value").set(443);
                } else {
                    transformedOperation = operation;
                }
                final boolean isVirtualServer = operation.get("name").asString().equals("virtual-server");
                return new OperationTransformer.TransformedOperation(transformedOperation, new OperationRejectionPolicy(){

                    public boolean rejectOperation(ModelNode preparedResult) {
                        return isVirtualServer;
                    }

                    public String getFailureDescription() {
                        return WebMessages.MESSAGES.transformationVersion_1_1_0_JBPAPP_9314();
                    }
                }, OperationResultTransformer.ORIGINAL_RESULT);
            }
        }, reject.getWriteAttributeTransformer()}));
        connectors.registerOperationTransformer("undefine-attribute", new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                ModelNode transformedOperation;
                String attributeName = operation.get("name").asString();
                if (WebConnectorDefinition.REDIRECT_PORT.getName().equals(attributeName)) {
                    transformedOperation = operation.clone();
                    transformedOperation.get("operation").set("write-attribute");
                    transformedOperation.get("value").set(443);
                } else {
                    transformedOperation = operation;
                }
                return new OperationTransformer.TransformedOperation(transformedOperation, OperationResultTransformer.ORIGINAL_RESULT);
            }
        });
        TransformersSubRegistration virtualHost = WebExtension.rejectExpressions(transformers, HOST_PATH, new AttributeDefinition[]{WebVirtualHostDefinition.DEFAULT_WEB_MODULE});
        WebExtension.rejectExpressions(virtualHost, SSL_PATH, (AttributeDefinition[])WebSSLDefinition.SSL_ATTRIBUTES);
        TransformersSubRegistration rewritePath = WebExtension.rejectExpressions(virtualHost, REWRITE_PATH, new AttributeDefinition[]{WebReWriteDefinition.FLAGS, WebReWriteDefinition.PATTERN, WebReWriteDefinition.SUBSTITUTION});
        WebExtension.rejectExpressions(rewritePath, REWRITECOND_PATH, (AttributeDefinition[])WebReWriteConditionDefinition.ATTRIBUTES);
        connectors.registerSubResource(SSL_PATH, (CombinedTransformer)AliasOperationTransformer.replaceLastElement((PathElement)SSL_ALIAS));
        TransformersSubRegistration virtualServer = transformers.registerSubResource(HOST_PATH);
        TransformersSubRegistration sso = virtualServer.registerSubResource(SSO_PATH, (CombinedTransformer)AliasOperationTransformer.replaceLastElement((PathElement)SSO_ALIAS));
        TransformersSubRegistration accessLog = virtualServer.registerSubResource(ACCESS_LOG_PATH, (CombinedTransformer)AliasOperationTransformer.replaceLastElement((PathElement)ACCESS_LOG_ALIAS));
        accessLog.registerSubResource(DIRECTORY_PATH, (CombinedTransformer)AliasOperationTransformer.create((AliasOperationTransformer.AddressTransformer)new AliasOperationTransformer.AddressTransformer(){

            public PathAddress transformAddress(PathAddress address) {
                PathAddress copy = PathAddress.EMPTY_ADDRESS;
                for (PathElement element : address) {
                    if (element.getKey().equals("configuration")) {
                        copy = copy.append(new PathElement[]{ACCESS_LOG_ALIAS});
                        continue;
                    }
                    if (element.getKey().equals("setting")) {
                        copy = copy.append(new PathElement[]{DIRECTORY_ALIAS});
                        continue;
                    }
                    copy = copy.append(new PathElement[]{element});
                }
                return copy;
            }
        }));
    }

    private static TransformersSubRegistration rejectExpressions(TransformersSubRegistration parent, PathElement path, AttributeDefinition ... definitions) {
        return WebExtension.rejectExpressions(parent, path, WebExtension.getKeys(definitions));
    }

    private static TransformersSubRegistration rejectExpressions(TransformersSubRegistration parent, PathElement path, Set<String> expressionKeys) {
        RejectExpressionValuesTransformer operationTransformer = new RejectExpressionValuesTransformer(expressionKeys);
        TransformersSubRegistration registration = parent.registerSubResource(path, operationTransformer.getResourceTransformer());
        registration.registerOperationTransformer("add", (OperationTransformer)operationTransformer);
        registration.registerOperationTransformer("write-attribute", operationTransformer.getWriteAttributeTransformer());
        return registration;
    }

    private static Set<String> getKeys(AttributeDefinition ... definitions) {
        HashSet<String> keys = new HashSet<String>();
        for (AttributeDefinition definition : definitions) {
            if (!definition.isAllowExpression()) continue;
            keys.add(definition.getName());
        }
        return keys;
    }

    private static class StandardWebExtensionAliasEntry
    extends AliasEntry {
        public StandardWebExtensionAliasEntry(ManagementResourceRegistration target) {
            super(target);
        }

        public PathAddress convertToTargetAddress(PathAddress addr) {
            PathAddress targetAddress = this.getTargetAddress();
            ArrayList<PathElement> list = new ArrayList<PathElement>();
            int i = 0;
            for (PathElement element : addr) {
                String key = element.getKey();
                try {
                    if (i < targetAddress.size() && (key.equals("ssl") || key.equals("sso") || key.equals("access-log") || key.equals("directory"))) {
                        list.add(targetAddress.getElement(i));
                    } else {
                        list.add(element);
                    }
                    ++i;
                }
                catch (Exception e) {
                    throw new RuntimeException("Bad " + addr + " " + targetAddress);
                }
            }
            return PathAddress.pathAddress(list);
        }
    }
}

