/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.List;
import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.web.Namespace;
import org.jboss.dmr.ModelNode;

public class DefaultJsfProfileCompletionHandler
implements ProfileParsingCompletionHandler {
    private static final String JSF_NAMESPACE_PREFIX = "urn:jboss:domain:jsf:";
    private static final String JSF_SUBSYSTEM = "jsf";
    private static final String JSF_MODULE = "org.jboss.as.jsf";

    public void handleProfileParsingCompletion(Map<String, List<ModelNode>> profileBootOperations, List<ModelNode> otherBootOperations) {
        List<ModelNode> legacyWebOps = profileBootOperations.get(Namespace.WEB_1_0.getUriString());
        if (legacyWebOps == null) {
            legacyWebOps = profileBootOperations.get(Namespace.WEB_1_1.getUriString());
        }
        if (legacyWebOps != null) {
            boolean hasJsf = false;
            for (String namespace : profileBootOperations.keySet()) {
                if (!namespace.startsWith(JSF_NAMESPACE_PREFIX)) continue;
                hasJsf = true;
                break;
            }
            if (!hasJsf) {
                boolean hasJSFExtension = false;
                for (ModelNode op : otherBootOperations) {
                    PathAddress pa = PathAddress.pathAddress((ModelNode)op.get("address"));
                    if (pa.size() != 1 || !"extension".equals(pa.getElement(0).getKey()) || !JSF_MODULE.equals(pa.getElement(0).getValue())) continue;
                    hasJSFExtension = true;
                    break;
                }
                if (!hasJSFExtension) {
                    ModelNode jsfExtension = new ModelNode();
                    jsfExtension.get("operation").set("add");
                    PathAddress jsfExtensionAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"extension", (String)JSF_MODULE)});
                    jsfExtension.get("address").set(jsfExtensionAddress.toModelNode());
                    jsfExtension.get("module").set(JSF_MODULE);
                    otherBootOperations.add(jsfExtension);
                }
                ModelNode jsf = new ModelNode();
                jsf.get("operation").set("add");
                PathAddress jsfAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)JSF_SUBSYSTEM)});
                jsf.get("address").set(jsfAddress.toModelNode());
                legacyWebOps.add(jsf);
            }
        }
    }
}

