/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.blocks.TCPConnectionMap;
import org.jgroups.protocols.BasicTCP;
import org.jgroups.util.SocketFactory;

public class TCP
extends BasicTCP
implements TCPConnectionMap.Receiver {
    private TCPConnectionMap ct = null;

    @ManagedAttribute
    public int getOpenConnections() {
        return this.ct.getNumConnections();
    }

    @Override
    @ManagedOperation
    public String printConnections() {
        return this.ct.printConnections();
    }

    @Override
    public void setSocketFactory(SocketFactory factory) {
        super.setSocketFactory(factory);
        if (this.ct != null) {
            this.ct.setSocketFactory(factory);
        }
    }

    @Override
    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        if (this.ct != null) {
            this.ct.send(dest, data, offset, length);
        }
    }

    @Override
    public void retainAll(Collection<Address> members) {
        this.ct.retainAll(members);
    }

    @Override
    public void start() throws Exception {
        this.ct = this.createConnectionMap(this.reaper_interval, this.conn_expire_time, this.bind_addr, this.external_addr, this.external_port, this.bind_port, this.bind_port + this.port_range, this.getChannelThreadGroup());
        this.ct.setReceiveBufferSize(this.recv_buf_size);
        this.ct.setSendQueueSize(this.send_queue_size);
        this.ct.setUseSendQueues(this.use_send_queues);
        this.ct.setSendBufferSize(this.send_buf_size);
        this.ct.setSocketConnectionTimeout(this.sock_conn_timeout);
        this.ct.setTcpNodelay(this.tcp_nodelay);
        this.ct.setLinger(this.linger);
        this.ct.setSocketFactory(this.getSocketFactory());
        super.start();
    }

    @Override
    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("closing sockets and stopping threads");
        }
        this.ct.stop();
        super.stop();
    }

    @Override
    protected void handleConnect() throws Exception {
        if (this.isSingleton()) {
            if (this.connect_count == 0) {
                this.ct.start();
            }
            super.handleConnect();
        } else {
            this.ct.start();
        }
    }

    @Override
    protected void handleDisconnect() {
        if (this.isSingleton()) {
            super.handleDisconnect();
            if (this.connect_count == 0) {
                this.ct.stop();
            }
        } else {
            this.ct.stop();
        }
    }

    protected TCPConnectionMap createConnectionMap(long reaperInterval, long connExpireTime, InetAddress bindAddress, InetAddress externalAddress, int external_port, int startPort, int endPort, ThreadGroup group) throws Exception {
        TCPConnectionMap cTable;
        if (reaperInterval == 0L && connExpireTime == 0L) {
            cTable = new TCPConnectionMap("jgroups.tcp.srv_sock", this.getThreadFactory(), this.getSocketFactory(), this, bindAddress, externalAddress, external_port, startPort, endPort, null).clientBindAddress(this.client_bind_addr).clientBindPort(this.client_bind_port);
        } else {
            if (reaperInterval == 0L) {
                reaperInterval = 5000L;
                if (this.log.isWarnEnabled()) {
                    this.log.warn("reaper_interval was 0, set it to " + reaperInterval);
                }
            }
            if (connExpireTime == 0L) {
                connExpireTime = 300000L;
                if (this.log.isWarnEnabled()) {
                    this.log.warn("conn_expire_time was 0, set it to " + connExpireTime);
                }
            }
            cTable = new TCPConnectionMap("jgroups.tcp.srv_sock", this.getThreadFactory(), this.getSocketFactory(), this, bindAddress, externalAddress, external_port, startPort, endPort, reaperInterval, connExpireTime, null).clientBindAddress(this.client_bind_addr).clientBindPort(this.client_bind_port);
        }
        return cTable;
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.ct != null ? (PhysicalAddress)this.ct.getLocalAddress() : null;
    }
}

