/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.TP;

public abstract class BasicTCP
extends TP {
    @Property(description="Reaper interval in msec. Default is 0 (no reaping)")
    protected long reaper_interval = 0L;
    @Property(description="Max time connection can be idle before being reaped (in ms)")
    protected long conn_expire_time = 0L;
    @Property(description="Should separate send queues be used for each connection")
    protected boolean use_send_queues = true;
    @Property(description="Max number of messages in a send queue")
    protected int send_queue_size = 10000;
    @Property(description="Receiver buffer size in bytes")
    protected int recv_buf_size = 150000;
    @Property(description="Send buffer size in bytes")
    protected int send_buf_size = 150000;
    @Property(description="Max time allowed for a socket creation in connection table")
    protected int sock_conn_timeout = 2000;
    @Property(description="Max time to block on reading of peer address")
    protected int peer_addr_read_timeout = 1000;
    @Property(description="Should TCP no delay flag be turned on")
    protected boolean tcp_nodelay = true;
    @Property(description="SO_LINGER in msec. Default of -1 disables it")
    protected int linger = -1;
    @LocalAddress
    @Property(name="client_bind_addr", description="The address of a local network interface which should be used by client sockets to bind to. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", systemProperty={"jgroups.tcp.client_bind_addr"}, writable=false)
    protected InetAddress client_bind_addr = null;
    @Property(description="The local port a client socket should bind to. If 0, an ephemeral port will be picked.")
    protected int client_bind_port = 0;

    protected BasicTCP() {
    }

    @Override
    public boolean supportsMulticasting() {
        return false;
    }

    public long getReaperInterval() {
        return this.reaper_interval;
    }

    public void setReaperInterval(long reaper_interval) {
        this.reaper_interval = reaper_interval;
    }

    public long getConnExpireTime() {
        return this.conn_expire_time;
    }

    public void setConnExpireTime(long conn_expire_time) {
        this.conn_expire_time = conn_expire_time;
    }

    @Override
    public void init() throws Exception {
        Discovery discovery_prot;
        super.init();
        if (!this.isSingleton() && this.bind_port <= 0 && (discovery_prot = (Discovery)this.stack.findProtocol((Class<?>)Discovery.class)) != null && !discovery_prot.isDynamic()) {
            throw new IllegalArgumentException("bind_port cannot be set to " + this.bind_port + ", as no dynamic discovery protocol (e.g. MPING or TCPGOSSIP) has been detected.");
        }
    }

    @Override
    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        this.sendToAllPhysicalAddresses(data, offset, length);
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=" + dest + " (" + length + " bytes)");
        }
        this.send(dest, data, offset, length);
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("connections: ").append(this.printConnections()).append("\n");
        return sb.toString();
    }

    public abstract String printConnections();

    public abstract void send(Address var1, byte[] var2, int var3, int var4) throws Exception;

    public abstract void retainAll(Collection<Address> var1);

    @Override
    public void receive(Address sender, byte[] data, int offset, int length) {
        super.receive(sender, data, offset, length);
    }

    @Override
    protected Object handleDownEvent(Event evt) {
        Object ret = super.handleDownEvent(evt);
        if (evt.getType() == 6) {
            HashSet<Address> physical_mbrs = new HashSet<Address>();
            for (Address addr : this.members) {
                PhysicalAddress physical_addr = this.getPhysicalAddressFromCache(addr);
                if (physical_addr == null) continue;
                physical_mbrs.add(physical_addr);
            }
            this.retainAll(physical_mbrs);
        }
        return ret;
    }
}

